define(
        ['jquery', 'underscore', 'underscore.string', 'pgadmin', 'pgadmin.browser', 'alertify', 'pgadmin.browser.collection'],
function($, _, S, pgAdmin, pgBrowser, alertify) {

  if (!pgBrowser.Nodes['coll-table']) {
    var databases = pgAdmin.Browser.Nodes['coll-table'] =
      pgAdmin.Browser.Collection.extend({
        node: 'table',
        label: '{{ _('Tables') }}',
        type: 'coll-table',
        columns: ['name', 'oid', 'description']
      });
  };

  var switchOptions = {
    'onText': 'Yes', 'offText': 'No',
    'onColor': 'success', 'offColor': 'default',
    'size': 'small'
  };

   var SecurityModel = Backform.SecurityModel = pgAdmin.Browser.Node.Model.extend({
    defaults: {
      provider: null,
      security_label: null
    },
    schema: [{
      id: 'provider', label: '{{ _('Provider') }}',
      type: 'text', disabled: false
    },{
      id: 'security_label', label: '{{ _('Security Label') }}',
      type: 'text', disabled: false
    }],
    validate: function() {
      var err = {},
          errmsg = null;

      if (_.isUndefined(this.get('security_label')) ||
        _.isNull(this.get('security_label')) ||
        String(this.get('security_label')).replace(/^\s+|\s+$/g, '') == '') {
            errmsg =  '{{ _('Please specify the value for all the security providers.')}}';
            this.errorModel.set('security_label', errmsg);
            return errmsg;
          } else {
            this.errorModel.unset('security_label');
          }
      return null;
    }
  });

   var ColumnsModel = pgAdmin.Browser.Node.Model.extend({
    idAttribute: 'attname',
    defaults: {
      attname: undefined,
      definition: undefined,
      inheritedfrom: undefined
    },
    schema: [
        {id: 'attname', label:'{{ _('Name') }}', cell: 'string', type: 'text' },
        {id: 'definition', label:'{{ _('Definition') }}', cell: 'string', type: 'text' },
        {id: 'inheritedfrom', label:'{{ _('Inherited From') }}',
         cell: 'string',type: 'text', visible: false, mode: ['properties']}
    ],
    validate: function() {
      // TODO: Add validation here
    },
    toJSON: Backbone.Model.prototype.toJSON
  });

  if (!pgBrowser.Nodes['table']) {
    pgAdmin.Browser.Nodes['table'] = pgBrowser.Node.extend({
      type: 'table',
      label: '{{ _('Table') }}',
      collection_type: 'coll-table',
      hasSQL: true,
      parent_type: ['schema', 'catalog'],
      Init: function() {
        /* Avoid mulitple registration of menus */
        if (this.initialized)
            return;

        this.initialized = true;

        pgBrowser.add_menus([{
          name: 'create_table_on_coll', node: 'coll-table', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Table...') }}',
          icon: 'wcTabIcon icon-table', data: {action: 'create', check: true},
          enable: 'canCreate'
        },{
          name: 'create_table', node: 'table', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Table...') }}',
          icon: 'wcTabIcon icon-table', data: {action: 'create', check: true},
          enable: 'canCreate'
        },{
          name: 'create_table', node: 'schema', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Table...') }}',
          icon: 'wcTabIcon icon-table', data: {action: 'create', check: false},
          enable: 'canCreate'
        }
        ]);
      },
      canDrop: pgBrowser.Nodes['schema'].canChildDrop,
      canDropCascade: pgBrowser.Nodes['schema'].canChildDrop,
      model: pgAdmin.Browser.Node.Model.extend({
        defaults: {
          name: undefined,
          oid: undefined,
          spcoid: undefined,
          spcname: 'pg_default',
          relowner: undefined,
          relacl: undefined,
          relhasoids: undefined,
          relhassubclass: undefined,
          reltuples: undefined,
          description: undefined,
          conname: undefined,
          conkey: undefined,
          isrepl: undefined,
          triggercount: undefined,
          relpersistence: undefined,
          fillfactor: undefined,
          autovacuum_enabled: undefined,
          autovacuum_vacuum_threshold: undefined,
          autovacuum_vacuum_scale_factor: undefined,
          autovacuum_analyze_threshold: undefined,
          autovacuum_analyze_scale_factor: undefined,
          autovacuum_vacuum_cost_delay: undefined,
          autovacuum_vacuum_cost_limit: undefined,
          autovacuum_freeze_min_age: undefined,
          autovacuum_freeze_max_age: undefined,
          autovacuum_freeze_table_age: undefined,
          toast_autovacuum_enabled: undefined,
          toast_autovacuum_vacuum_threshold: undefined,
          toast_autovacuum_vacuum_scale_factor: undefined,
          toast_autovacuum_analyze_threshold: undefined,
          toast_autovacuum_analyze_scale_factor: undefined,
          toast_autovacuum_vacuum_cost_delay: undefined,
          toast_autovacuum_vacuum_cost_limit: undefined,
          toast_autovacuum_freeze_min_age: undefined,
          toast_autovacuum_freeze_max_age: undefined,
          toast_autovacuum_freeze_table_age: undefined,
          toast_reloptions: undefined,
          hastoasttable: undefined,
          reloftype: undefined,
          typname: undefined,
          labels: undefined,
          providers: undefined,
          is_sys_table: undefined
       },
        schema: [{
          id: 'name', label: '{{ _('Name') }}', cell: 'string',
          type: 'text', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchema'
        },{
          id: 'oid', label:'{{ _('Oid') }}', cell: 'string',
          type: 'text' , mode: ['properties']
        },{
          id: 'relowner', label:'{{ _('Owner') }}', cell: 'string',
          type: 'text', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchema', control: 'node-list-by-name',
          node: 'role', select2: { allowClear: false }
        },{
          id: 'schema', label:'{{ _('Schema') }}', cell: 'string',
          control: 'node-list-by-name',
          type: 'text', mode: ['create', 'edit'], node: 'schema',
          disabled: 'inSchema', filter: function(d) {
            // If schema name start with pg_* then we need to exclude them
            if(d && d.label.match(/^pg_/))
            {
              return false;
            }
            return true;
          }
        },{
          id: 'spcname', label:'{{ _('Tablespace') }}', cell: 'string', control: 'node-list-by-name',
          type: 'text', mode: ['properties', 'create', 'edit'], node: 'tablespace',
          disabled: 'inSchema', filter: function(d) {
            // If tablespace name is not "pg_global" then we need to exclude them
            if(d && d.label.match(/pg_global/))
            {
              return false;
            }
            return true;
          }
        },{
          id: 'description', label:'{{ _('Comment') }}', cell: 'string',
          type: 'multiline', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchema'
        },{
          id: 'relhasoids', label:'{{ _('Has OIDs?') }}', cell: 'switch',
          type: 'switch', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchema', 'options': switchOptions
        },{
          id: 'typname', label:'{{ _('Of type') }}', cell: 'string', control: 'node-ajax-options',
          type: 'text', mode: ['properties', 'create', 'edit'],
          disabled: 'checkOfType', url: 'get_oftype', group: 'Advance', deps: ['coll_inherits']
        },{
          id: 'conname', label:'{{ _('Primary Key') }}', cell: 'string',
          type: 'text', mode: ['properties'],
          disabled: 'inSchema'
        },{
          id: 'reltuples', label:'{{ _('Rows (estimated)') }}', cell: 'string',
          type: 'text', mode: ['properties'],
          disabled: 'inSchema'
        },{
          id: 'rows_cnt', label:'{{ _('Rows (counted)') }}', cell: 'string',
          type: 'text', mode: ['properties'],
          disabled: 'inSchema'
        },{
          id: 'relhassubclass', label:'{{ _('Inherits tables') }}', cell: 'switch',
          type: 'switch', mode: ['properties'],
          disabled: 'inSchema', 'options': switchOptions
        },{
          id: 'inherited_tables', label:'{{ _('Inherited tables') }}', cell: 'string',
          type: 'text', mode: ['properties'],
          disabled: 'inSchema'
        },{
          id: 'inherited_tables_cnt', label:'{{ _('Inherited tables count') }}', cell: 'string',
          type: 'text', mode: ['properties'],
          disabled: 'inSchema'
        },{
          id: 'relpersistence', label:'{{ _('Unlogged?') }}', cell: 'switch',
          type: 'switch', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchemaWithModelCheck', 'options': switchOptions,
          group: 'Advance'
        },{
          id: 'is_sys_table', label:'{{ _('System tabel?') }}', cell: 'switch',
          type: 'switch', mode: ['properties'],
          disabled: 'inSchema', 'options': switchOptions
        },{
          id: 'coll_inherits', label: '{{ _('Inherits') }}',
          control: 'node-ajax-options', url: 'get_inherits',
          //control: 'node-ajax-options-multiple', url: 'get_inherits',
          disabled: 'checkInheritance', deps: ['typname'],
          select2: { multiple: true, allowClear: true,
          placeholder: 'Select to inherit from'}
        },{
          type: 'nested', control: 'fieldset', label: '{{ _('Columns') }}',
          schema:[{
             // TODO: Add columns sub node here
            id: 'columns', label:'{{ _('Columns') }}', cell: 'string',
            type: 'text', mode: ['properties', 'create', 'edit'],
            disabled: 'inSchema', group: 'Columns'
          }]
        },{
          type: 'nested', control: 'fieldset', label: '{{ _('Constraints') }}',
          schema:[{
             // TODO: Add Constraints sub node here
            id: 'dummy', label:'{{ _('dummy') }}', cell: 'string',
            type: 'text', mode: ['properties', 'create', 'edit'],
            disabled: 'inSchema', group: 'Constraints'
          }]
        },{
          type: 'nested', control: 'fieldset', label: '{{ _('Like') }}',
          group: '{{ _('Advance') }}',
          schema:[{
            id: 'like_relation', label:'{{ _('Relation') }}', cell: 'string',
            type: 'text', mode: ['create', 'edit'],
            control: 'node-ajax-options', url: 'get_relations',
            disabled: 'inSchema', group: 'Like'
          },{
            id: 'like_default_value', label:'{{ _('With Default values?') }}', cell: 'switch',
            type: 'switch', mode: ['create', 'edit'],
            disabled: 'inSchema', 'options': switchOptions, group: 'Like'
          },{
            id: 'like_constraints', label:'{{ _('With Constraints?') }}', cell: 'switch',
            type: 'switch', mode: ['create', 'edit'],
            disabled: 'inSchema', 'options': switchOptions, group: 'Like'
          },{
            id: 'like_indexes', label:'{{ _('With Indexes?') }}', cell: 'switch',
            type: 'switch', mode: ['create', 'edit'],
            disabled: 'inSchema', 'options': switchOptions, group: 'Like'
          },{
            id: 'like_storage', label:'{{ _('With Storage?') }}', cell: 'switch',
            type: 'switch', mode: ['create', 'edit'],
            disabled: 'inSchema', 'options': switchOptions, group: 'Like'
          },{
            id: 'like_comments', label:'{{ _('With Comments?') }}', cell: 'switch',
            type: 'switch', mode: ['create', 'edit'],
            disabled: 'inSchema', 'options': switchOptions, group: 'Like'
          }]
        },{
          id: 'fillfactor', label:'{{ _('Fill factor') }}', cell: 'integer',
          type: 'int', mode: ['properties', 'create', 'edit'], min: 10, max: 100,
          disabled: 'inSchema',group: '{{ _('Auto vacuum') }}'
        },{
          // Here we will create tab control for auto-vacuum
          type: 'nested', control: 'tab', group: '{{ _('Auto vacuum') }}',
          mode: ['edit', 'create'],
          schema:[{
            id: 'tblautovacuum', label:'{{ _('Custom Auto-Vacuum?') }}',
            type: 'switch', group: 'Table', disabled: 'inSchema',
            options: switchOptions, node: this
          },{
            id: 'autovacuum_enabled', label:'{{ _('Enable?') }}',
            type: 'switch', group: 'Table',
            options: switchOptions, deps: ['tblautovacuum'], node: this,
            disabled: function(m) {
              if(!m.inSchema.apply(this, [m]) &&
                  m.get('tblautovacuum') == true) {
                return false;
              }
              // we also need to unset rest of all
              m.set('autovacuum_enabled', false);
              return true;
            }
          },{
            id: 'autovacuum_vacuum_threshold', label: '{{ _('Vacuum Threshold') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_vacuum_scale_factor', label: '{{ _('Vacuum Scale Factor') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_analyze_threshold', label: '{{ _('Vacuum Analyze Threshold') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_analyze_scale_factor', label: '{{ _('Vacuum Analyze Scale Factor') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_vacuum_cost_delay', label: '{{ _('Vacuum Cost Delay') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_vacuum_cost_limit', label: '{{ _('Vacuum Cost Limit') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_freeze_min_age', label: '{{ _('Freeze Minimum Age') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_freeze_max_age', label: '{{ _('Freeze Maximum Age') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'autovacuum_freeze_table_age', label: '{{ _('Freeze Table Age') }}',
            type: 'text', disabled: 'isTableAutoVacuumEnable',
            group: 'Table', deps: ['autovacuum_enabled']
          },{
            id: 'toasttblautovacuum', label:'{{ _('Custom Auto-Vacuum?') }}',
            type: 'switch', group: 'Toast Table', disabled: 'inSchemaWithModelCheck',
            options: switchOptions
          },{
            id: 'toast_autovacuum_enabled', label:'{{ _('Enable?') }}',
            type: 'switch', group: 'Toast Table',
            options: switchOptions, deps: ['toasttblautovacuum'],
            disabled: function(m) {
              if(!m.inSchemaWithModelCheck.apply(this, [m]) &&
                  m.get('toasttblautovacuum') == true) {
                return false;
              }
              // we also need to unset rest of all
              m.set('toast_autovacuum_enabled', false);
              return true;
            }
          },{
            id: 'toast_autovacuum_vacuum_threshold', label: '{{ _('Vacuum Threshold') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_vacuum_scale_factor', label: '{{ _('Vacuum Scale Factor') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_vacuum_cost_delay', label: '{{ _('Vacuum Cost Delay') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_vacuum_cost_limit', label: '{{ _('Vacuum Cost Limit') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_freeze_min_age', label: '{{ _('Freeze Minimum Age') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_freeze_max_age', label: '{{ _('Freeze Maximum Age') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          },{
            id: 'toast_autovacuum_freeze_table_age', label: '{{ _('Freeze Table Age') }}',
            type: 'text', disabled: 'isToastTableAutoVacuumEnable',
            group: 'Toast Table', deps: ['toast_autovacuum_enabled']
          }]
        },{
          id: 'relacl', label: 'Privileges', type: 'collection',
          group: '{{ _('Security') }}', control: 'unique-col-collection',
          model: pgAdmin.Browser.Node.PrivilegeRoleModel.extend({
          privileges: ['a','r','w','d','D','x','t']}),
          mode: ['properties', 'edit', 'create'], canAdd: true, canDelete: true,
          uniqueCol : ['grantee']
        },{
          id: 'seclabels', label: '{{ _('Security Labels') }}',
          model: SecurityModel, editable: false, type: 'collection',
          group: '{{ _('Security') }}', mode: ['edit', 'create'],
          min_version: 90200, canAdd: true,
          canEdit: false, canDelete: true, control: 'unique-col-collection'
        }],
        validate: function() {
          var err = {},
              changedAttrs = this.changed,
              msg = undefined;
          this.errorModel.clear();

          if (_.has(changedAttrs,this.get('name'))
                    && _.isUndefined(this.get('name'))
              || String(this.get('name')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Name can not be empty!') }}';
            this.errorModel.set('name', msg);
            return msg;
          } else if (_.has(changedAttrs,this.get('schema'))
                        && _.isUndefined(this.get('schema'))
              || String(this.get('schema')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Schema can not be empty!') }}';
            this.errorModel.set('schema', msg);
            return msg;
          } else if (_.has(changedAttrs,this.get('relowner'))
                        && _.isUndefined(this.get('relowner'))
              || String(this.get('relowner')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Owner can not be empty!') }}';
            this.errorModel.set('relowner', msg);
            return msg;

          }
          return null;
        },
        // We will disable everything if we are under catalog node
        inSchema: function() {
          if(this.node_info &&  'catalog' in this.node_info)
          {
            return true;
          }
          return false;
        },
        // We will disable it if Oftype is defined
        checkInheritance: function(m) {
        //coll_inherits || typname
          if(!m.inSchema.apply(this, [m]) &&
              ( _.isUndefined(m.get('typname')) ||
                _.isNull(m.get('typname')) ||
                String(m.get('typname')).replace(/^\s+|\s+$/g, '') == '')) {
            return false;
          }
          return true;
        },
        // We will disable it if Inheritance is defined
        checkOfType: function(m) {
        //coll_inherits || typname
          if(!m.inSchema.apply(this, [m]) &&
              (_.isUndefined(m.get('coll_inherits')) ||
               _.isNull(m.get('coll_inherits')) ||
               String(m.get('coll_inherits')).replace(/^\s+|\s+$/g, '') == '')) {
            return false;
          }
          return true;
        },
        // We will check if we are under schema node & in 'create' mode
        inSchemaWithModelCheck: function(m) {
          if(this.node_info &&  'schema' in this.node_info)
          {
            // We will disbale control if it's in 'edit' mode
            if (m.isNew()) {
              return false;
            } else {
              return true;
            }
          }
          return true;    
        },
        isTableAutoVacuumEnable: function(m) {
          // We need to check additional condition to toggle enable/disable
          // for table auto-vacuum
          if(!m.inSchema.apply(this, [m]) &&
              m.get('autovacuum_enabled') === true) {
            return false;
          }
          return true;
        },
        isToastTableAutoVacuumEnable: function(m) {
          // We need to check additional condition to toggle enable/disable
          // for toast table auto-vacuum
          if(!m.inSchemaWithModelCheck.apply(this, [m]) &&
              m.get('toast_autovacuum_enabled') == true) {
            return false;
          }
          return true;
        }
      }),
      canCreate: function(itemData, item, data) {
          //If check is false then , we will allow create menu
          if (data && data.check == false)
            return true;

          var t = pgBrowser.tree, i = item, d = itemData;
          // To iterate over tree to check parent node
          while (i) {
            // If it is schema then allow user to create table
            if (_.indexOf(['schema'], d._type) > -1)
              return true;

            if ('coll-table' == d._type) {
              //Check if we are not child of catalog
              prev_i = t.hasParent(i) ? t.parent(i) : null;
              prev_d = prev_i ? t.itemData(prev_i) : null;
              if( prev_d._type == 'catalog') {
                return false;
              } else {
                return true;
              }                
            }
            i = t.hasParent(i) ? t.parent(i) : null;
            d = i ? t.itemData(i) : null;
          }
          // by default we do not want to allow create menu
          return true;
      }
  });

  }

  return pgBrowser.Nodes['table'];
});
