define(
        ['jquery', 'underscore', 'underscore.string', 'pgadmin',
        'pgadmin.browser', 'alertify', 'pgadmin.browser.collection'],
function($, _, S, pgAdmin, pgBrowser, alertify) {

  // Extend the browser's collection class for primary key collection
  if (!pgBrowser.Nodes['coll-primary_key']) {
    var databases = pgAdmin.Browser.Nodes['coll-primary_key'] =
      pgAdmin.Browser.Collection.extend({
        node: 'primary_key',
        label: '{{ _('Primary key') }}',
        type: 'coll-primary_key',
      });
  };

  // Extend the browser's node class for primary key node
  if (!pgBrowser.Nodes['primary_key']) {
    pgAdmin.Browser.Nodes['primary_key'] = pgBrowser.Node.extend({
      type: 'primary_key',
      label: '{{ _('Primary key') }}',
      collection_type: 'coll-constraints',
      hasSQL: true,
      hasDepends: false,
      parent_type: 'table',
      canDrop: true,
      canDropCascade: true,
      Init: function() {
        /* Avoid multiple registration of menus */
        if (this.initialized)
            return;

        this.initialized = true;

        pgBrowser.add_menus([{
          name: 'create_primary_key_on_coll', node: 'coll-constraints', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Primary key...') }}',
          icon: 'wcTabIcon icon-primary_key', data: {action: 'create', check: true},
          enable: 'canCreate'
        }
        ]);
      },
      canCreate: function(node, item, data) {
        // There should be only one primary key per table.
        var children = pgBrowser.tree.children(arguments[1], false);

        _.each(children, function(child){
          data = pgBrowser.tree.itemData($(child));
          if (data._type == "primary_key") {
            return false;
          }
        });

        return true;
      },
      // Define the model for primary key node
      model: pgAdmin.Browser.Node.Model.extend({
        defaults: {
          name: undefined,
          oid: undefined,
          comment: undefined,
          spcname: "pg_default",
          index: undefined,
          fillfactor: undefined,
          condeferrable: undefined,
          condeferred: undefined,
          columns: []
        },

        // Define the schema for the primary key node
        schema: [{
          id: 'name', label: '{{ _('Name') }}', type: 'text',
          mode: ['properties', 'create', 'edit']
        },{
          id: 'oid', label:'{{ _('OID') }}', cell: 'string',
          type: 'text' , mode: ['properties']
        },{
          id: 'comment', label:'{{ _('Comment') }}', cell: 'string',
          type: 'multiline', mode: ['properties', 'create', 'edit']
          },{
            id: 'columns', label: '{{ _('Columns') }}',
            type: 'collection', group: '{{ _('Definition') }}', editable:true,
            canDelete: true, canAdd: true,
            control: Backform.MultiSelectAjaxControl.extend({
              formatter: {
                fromRaw: function (rawData, model) {
                  var res = _.isObject(rawData) ?
                        rawData : JSON.parse(rawData);

                  return _.pluck(res, 'column');
                },
                toRaw: function (formattedData, model) {
                  return formattedData;
                }
              },
              defaults: _.extend(
                {},
                Backform.NodeListByNameControl.prototype.defaults,
                {
                  select2: {
                    multiple: true,
                    allowClear: true,
                    width: 'style',
                    placeholder: '{{ _('Select the column(s)') }}',
                  }
                }
              ),
              onChange: function(e) {
                var model = this.model,
                    $el = $(e.target),
                    attrArr = this.field.get("name").split('.'),
                    name = attrArr.shift(),
                    path = attrArr.join('.'),
                    vals = this.getValueFromDOM(),
                    collection = model.get(name),
                    removed = [];

                this.stopListening(this.model, "change:" + name, this.render);

                /*
                 * Iterate through all the values, and find out how many are already
                 * present in the collection.
                 */
                collection.each(function(m) {
                    var column = m.get('column'),
                        idx = _.indexOf(vals, column);

                    if (idx > -1) {
                      vals.splice(idx, 1);
                    } else {
                      removed.push(column);
                    }
                 });

                /*
                 * Adding new values
                 */
                _.each(vals, function(v) {
                  collection.add({column: v});
                });

                /*
                 * Removing unwanted!
                 */
                _.each(removed, function(v) {
                  collection.remove(collection.where({column: v}));
                });

                this.listenTo(this.model, "change:" + name, this.render);
              }
            }),
            deps: ['index'], node: 'column',
            model: pgBrowser.Node.Model.extend({
              defaults: {
                column: undefined
              },
              validate: function() {
                var columns = this.handler.get('columns');
                if ((!_.isUndefined(columns) && !_.isNull(columns) && columns.length > 0)) {
                  this.handler.errorModel.unset("columns");
                  this.handler.errorModel.clear();
                } else {
                  var msg = '{{ _('Please specify column(s).') }}';
                  this.handler.errorModel.set('columns', msg);
                  return msg;
                }
                return null;
             }
            }),
            transform : function(data){
              var res = [];
              if (data && _.isArray(data)) {
                _.each(data, function(d) {
                  res.push({label: d.label, value: d.label});
                })
              }
              return res;
            },
            select2:{allowClear:false},
            disabled: function(m) {
              // We can't update columns of existing primary key.
              if (!m.isNew()) {
                  return true;
              }
              // Disable if index is selected.
              var index = m.get('index');
                if(_.isUndefined(index) || index == '') {
                  return false;
                } else {
                  var col = m.get('columns');
                  col.reset();
                  return true;
                }
              }
          },{
          id: 'spcname', label: '{{ _('Tablespace') }}',
          type: 'text', group: '{{ _('Definition') }}',
          control: 'node-list-by-name', node: 'tablespace',
          deps: ['index'],
          select2:{allowClear:false},
          filter: function(m) {
            // Don't show pg_global tablespace in selection.
            if (m.label == "pg_global") return false;
            else return true;
          },
          disabled: function(m) {
            // Disable if index is selected.
            var index = m.get('index');
              if(_.isUndefined(index) || index == '') {
                return false;
              } else {
                setTimeout(function(){
                  m.set('spcname', '');
                },10);
                return true;
              }
          }
        },{
          id: 'index', label: '{{ _('Index') }}',
          type: 'text', group: '{{ _('Definition') }}',
          control: 'node-ajax-options', url:"indices",
          select2:{allowClear:true},
          disabled: function(m) {
            // We can't update index of existing primary key.
            return !m.isNew();
          }
        },{
          id: 'fillfactor', label: '{{ _('Fill factor') }}', deps: ['index'],
          type: 'int', group: '{{ _('Definition') }}', allowNull: true,
          disabled: function(m) {
            // Disable if index is selected.
            var index = m.get('index');
              if(_.isUndefined(index) || index == '') {
                return false;
              } else {
                setTimeout(function(){
                  m.set('fillfactor', null);
                },10);
                return true;
              }
            }
        },{
          id: 'condeferrable', label: '{{ _('Deferrable') }}',
          type: 'switch', group: '{{ _('Definition') }}', deps: ['index'],
          disabled: function(m) {
            // We can't update condeferrable of existing primary key.
            if (!m.isNew()) {
                return true;
            }
            // Disable if index is selected.
            var index = m.get('index');
            if(_.isUndefined(index) || index == '') {
              return false;
            } else {
              setTimeout(function(){
                m.set('condeferrable', false);
              },10);
              return true;
            }
          }
        },{
          id: 'condeferred', label: '{{ _('Deferred') }}',
          type: 'switch', group: '{{ _('Definition') }}',
          deps: ['condeferrable'],
          disabled: function(m) {
            // We can't update condeferred of existing primary key.
            if (!m.isNew()) {
              return true;
            }
            // Disable if condeferred is false or unselected.
            if(m.get('condeferrable') == true) {
              return false;
            } else {
              setTimeout(function(){
                m.set('condeferred', false);
              },10);
              return true;
            }
          }
        }
        ],
        validate: function() {
          this.errorModel.clear();

          var columns = this.get('columns'),
            index = this.get('index');

            if ((_.isUndefined(index) || String(index).replace(/^\s+|\s+$/g, '') == '') &&
                (_.isUndefined(columns) || _.isNull(columns) || columns.length < 1)) {
              var msg = '{{ _('Please specify columns.') }}';
              this.errorModel.set('columns', msg);
              return msg;
            }

          return null;
        }
      })
  });
  }

  return pgBrowser.Nodes['primary_key'];
});
