{% import 'macros/table/child/security.macros' as SECLABLE %}
{% import 'macros/table/child/privilege.macros' as PRIVILEGE %}
{% import 'macros/variable.macros' as VARIABLE %}
{% if data %}
{###  Rename column name ###}
{% if data.name != o_data.name %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  RENAME {{conn|qtIdent(o_data.name)}} TO {{conn|qtIdent(data.name)}};
{% endif %}

{###  Alter column type and collation ###}
{% if data.cltype and data.cltype != o_data.cltype %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  ALTER COLUMN {{conn|qtIdent(data.name)}} {{data.cltype}}{% if data.attlen %}
({{data.attlen}}{% if data.attprecision%}, {{data.attprecision}}{% endif %}){% endif %}{% if data.hasSqrBracket %}
[]{% endif %}{% if data.collspcname and data.collspcname != o_data.collspcname %}
 COLLATE {{data.collspcname}}{% endif %};
{% endif %}

{###  Alter column default value ###}
{% if data.defval and data.defval != o_data.defval %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  ALTER COLUMN {{conn|qtIdent(data.name)}} SET DEFAULT {{data.defval}};
{% endif %}

{###  Alter column not null value ###}
{% if 'attnotnull' in data %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  ALTER COLUMN {{conn|qtIdent(data.name)}} {% if data.attnotnull %}SET{% else %}DROP{% endif %} NOT NULL;
{% endif %}

{###  Alter column statistics value ###}
{% if data.attstatterget %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  ALTER COLUMN {{conn|qtIdent(data.name)}} SET STATISTICS {{data.attstatterget}};
{% endif %}

{###  Alter column storage value ###}
{% if data.attstorage %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
  ALTER COLUMN {{conn|qtIdent(data.name)}} SET STORAGE {%if data.attstorage == 'p' %}
PLAIN{% elif data.attstorage == 'm'%}MAIN{% elif data.attstorage == 'e'%}
EXTERNAL{% elif data.attstorage == 'x'%}EXTENDED{% endif %};
{% endif %}

{% if data.description %}
COMMENT ON COLUMN {{conn|qtIdent(data.schema, data.table, data.name)}}
  IS {{data.description|qtLiteral}};
{% endif %}

{# ==== To update column variables ==== #}
{% if 'attoptions' in data and data.attoptions|length > 0 %}
{% set variables = data.attoptions %}
{% if 'deleted' in variables and variables.deleted|length > 0 %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
{{ VARIABLE.UNSET(conn, 'COLUMN', data.name, variables.deleted) }}
{% endif %}
{% if 'added' in variables and variables.added|length > 0 %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
{{ VARIABLE.SET(conn, 'COLUMN', data.name, variables.added) }}
{% endif %}
{% if 'changed' in variables and variables.changed|length > 0 %}
ALTER TABLE {{conn|qtIdent(data.schema, data.table)}}
{{ VARIABLE.SET(conn, 'COLUMN', data.name, variables.changed) }}
{% endif %}
{% endif %}


{# ==== To update column privileges ==== #}
{# Change the privileges #}
{% if data.attacl %}
{% if 'deleted' in data.attacl %}
{% for priv in data.attacl.deleted %}
{{ PRIVILEGE.RESETALL(conn, priv.grantee, data.schema, data.table, data.name) }}
{% endfor %}
{% endif %}
{% if 'changed' in data.attacl %}
{% for priv in data.attacl.changed %}
{{ PRIVILEGE.RESETALL(conn, priv.grantee, data.schema, data.table, data.name) }}
{{ PRIVILEGE.APPLY(conn, data.schema, data.table, data.name, priv.grantee, priv.without_grant, priv.with_grant) }}
{% endfor %}
{% endif %}
{% if 'added' in data.attacl %}
{% for priv in data.attacl.added %}
{{ PRIVILEGE.APPLY(conn, data.schema, data.table, data.name, priv.grantee, priv.without_grant, priv.with_grant) }}
{% endfor %}
{% endif %}
{% endif %}


{### End main if ###}
{% endif%}