define(
        ['jquery', 'underscore', 'underscore.string', 'pgadmin', 'pgadmin.browser', 'alertify', 'pgadmin.browser.collection'],
function($, _, S, pgAdmin, pgBrowser, alertify) {

  if (!pgBrowser.Nodes['coll-column']) {
    var databases = pgAdmin.Browser.Nodes['coll-column'] =
      pgAdmin.Browser.Collection.extend({
        node: 'column',
        label: '{{ _('Columns') }}',
        type: 'coll-column',
        columns: ['name', 'atttypid', 'description']
      });
  };

   // To avoid repetition of switch options
   var switchOptions = {
     'onText': 'Yes', 'offText': 'No',
     'onColor': 'success', 'offColor': 'default',
     'size': 'small'
   };

   // This Node model will be used for Security label control for column
   var SecurityModel = Backform.SecurityModel = pgAdmin.Browser.Node.Model.extend({
    defaults: {
      provider: null,
      security_label: null
    },
    schema: [{
      id: 'provider', label: '{{ _('Provider') }}',
      type: 'text', disabled: false
    },{
      id: 'security_label', label: '{{ _('Security Label') }}',
      type: 'text', disabled: false
    }],
    validate: function() {
      var err = {},
          errmsg = null;

      if (_.isUndefined(this.get('security_label')) ||
        _.isNull(this.get('security_label')) ||
        String(this.get('security_label')).replace(/^\s+|\s+$/g, '') == '') {
            errmsg =  '{{ _('Please specify the value for all the security providers.')}}';
            this.errorModel.set('security_label', errmsg);
            return errmsg;
          } else {
            this.errorModel.unset('security_label');
          }
      return null;
    }
  });
   // This Node model will be used for variable control for column
   var VariablesModel = Backform.VariablesModel = pgAdmin.Browser.Node.Model.extend({
    defaults: {
      name: null,
      value: null
    },
    schema: [{
      id: 'name', label: '{{ _('Name') }}', cell: 'select2',
      type: 'text', disabled: false, node: 'column',
      options: [['n_distinct', 'n_distinct'],
      ['n_distinct_inherited','n_distinct_inherited']],
      select2: {placeholder: "Select variable"}
    },{
      id: 'value', label: '{{ _('Value') }}',
      type: 'text', disabled: false
    }],
    validate: function() {
      var err = {},
          errmsg = null;

      if (_.isUndefined(this.get('value')) ||
        _.isNull(this.get('value')) ||
        String(this.get('value')).replace(/^\s+|\s+$/g, '') == '') {
            errmsg =  '{{ _('Please provide input for variable.')}}';
            this.errorModel.set('value', errmsg);
            return errmsg;
          } else {
            this.errorModel.unset('value');
          }
      return null;
    }
  });


  if (!pgBrowser.Nodes['column']) {
    pgAdmin.Browser.Nodes['column'] = pgAdmin.Browser.Node.extend({
      parent_type: 'table',
      collection_type: 'coll-table',
      type: 'column',
      label: '{{ _('Column') }}',
      hasSQL:  true,
      canDrop: true,
      Init: function() {
        /* Avoid mulitple registration of menus */
        if (this.initialized)
            return;

        this.initialized = true;

        pgBrowser.add_menus([{
          name: 'create_column_on_coll', node: 'coll-column', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Column...') }}',
          icon: 'wcTabIcon icon-column', data: {action: 'create', check: true},
          enable: 'canCreate'
        },{
          name: 'create_column', node: 'column', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Column...') }}',
          icon: 'wcTabIcon icon-column', data: {action: 'create', check: true},
          enable: 'canCreate'
        },{
          name: 'create_column_onTable', node: 'table', module: this,
          applies: ['object', 'context'], callback: 'show_obj_properties',
          category: 'create', priority: 4, label: '{{ _('Column...') }}',
          icon: 'wcTabIcon icon-column', data: {action: 'create', check: true},
          enable: 'canCreate'
        }
        ]);
      },
      canDrop: pgBrowser.Nodes['schema'].canChildDrop,
      model: pgAdmin.Browser.Node.Model.extend({
        defaults: {
          attname: undefined,
          attowner: undefined,
          atttypid: undefined,
          attnum: undefined,
          cltype: undefined,
          collspcname: undefined,
          attacl: undefined,
          description: undefined,
          parent_tbl: undefined,
          min_val: undefined,
          max_val: undefined,
          edit_types: undefined
        },
        schema: [{
          id: 'name', label: '{{ _('Name') }}', cell: 'string',
          type: 'text', disabled: 'inSchemaWithColumnCheck'
        },{
          id: 'attnum', label:'{{ _('Position') }}', cell: 'string',
          type: 'text', disabled: 'inSchema', mode: ['properties']
        },{
          id: 'cltype', label:'{{ _('Data type') }}', cell: 'string',
          type: 'text', disabled: 'inSchemaWithColumnCheck',
          control: 'node-ajax-options', url: 'get_types',
          select2: { allowClear: false },
          transform: function(data) {
              /* We need different data in create mode & in edit mode
               * if we are in create mode then return data as it is
               * if we are in edit mode then we need to filter data
               */
              this.model.datatypes = data;
              var edit_types = this.model.get('edit_types'),
                result = [];
              if(this.model.isNew()) {
                return data;
              } else {
                //edit mode
                _.each(data, function(t) {
                  if (_.indexOf(edit_types, t.value) != -1) {
                    result.push(t);
                  }
                });
                return result;
              }
            }
        },{
          id: 'attlen', label:'{{ _('Length') }}', cell: 'string',
           deps: ['cltype'], type: 'int',
           disabled: function(m) {
             var of_type = m.get('cltype'),
               flag = true;
              _.each(m.datatypes, function(o) {
                if ( of_type == o.value ) {
                    if(o.length)
                    {
                      m.set('min_val', o.min_val, {silent: true});
                      m.set('max_val', o.max_val, {silent: true});
                      flag = false;
                    }
                }
              });
              return flag;
           }
        },{
          id: 'attprecision', label:'{{ _('Precision') }}', cell: 'string',
           deps: ['cltype'], type: 'int',
           disabled: function(m) {
             var of_type = m.get('cltype'),
               flag = true;
              _.each(m.datatypes, function(o) {
                if ( of_type == o.value ) {
                    if(o.precision)
                    {
                      m.set('min_val', o.min_val, {silent: true});
                      m.set('max_val', o.max_val, {silent: true});
                      flag = false;
                    }
                }
              });
              return flag;
           }
         },{
          id: 'collspcname', label:'{{ _('Collation') }}', cell: 'string',
          type: 'text', disabled: 'inSchemaWithModelCheck',
          control: 'node-ajax-options', url: 'get_collations'
        },{
          id: 'defval', label:'{{ _('Default Value') }}', cell: 'string',
          type: 'text', disabled: 'inSchemaWithColumnCheck'
        },{
          id: 'attnotnull', label:'{{ _('Not NULL') }}', cell: 'string',
          type: 'switch', disabled: 'inSchemaWithColumnCheck', options: switchOptions
        },{
          id: 'attstatterget', label:'{{ _('Statistics') }}', cell: 'string',
          type: 'text', disabled: 'inSchemaWithColumnCheck', mode: ['properties', 'edit']
        },{
          id: 'attstorage', label:'{{ _('Storage') }}',
          type: 'text', mode: ['properties', 'edit'],
          cell: 'string', disabled: 'inSchemaWithColumnCheck',
          control: 'select2', select2: { placeholder: "Select storage",
            allowClear: false,
            width: "100%"
          },
          options: [
            {label: "PLAIN", value: "p"},
            {label: "MAIN", value: "m"},
            {label: "EXTERNAL", value: "e"},
            {label: "EXTENDED", value: "x"},
           ]
        },{
          id: 'is_pk', label:'{{ _('Primary key?') }}',
          type: 'switch', disabled: true, mode: ['properties'],
          options: switchOptions
        },{
          id: 'is_fk', label:'{{ _('Foreign key?') }}',
          type: 'switch', disabled: true, mode: ['properties'],
          options: switchOptions
        },{
          id: 'is_inherited', label:'{{ _('Inherited?') }}',
          type: 'switch', disabled: true, mode: ['properties'],
          options: switchOptions
        },{
          id: 'tbls_inherited', label:'{{ _('Inherited from table(s)') }}',
          type: 'text', disabled: true, mode: ['properties'], deps: ['is_inherited'],
          visible: function(m) {
              if (!_.isUndefined(m.get('is_inherited')) && m.get('is_inherited')) {
                return true;
              } else {
                return false;
              }
          }
        },{
          id: 'is_sys_column', label:'{{ _('System Column?') }}', cell: 'string',
          type: 'switch', disabled: true, mode: ['properties'],
          options: switchOptions
        },{
          id: 'description', label:'{{ _('Comment') }}', cell: 'string',
          type: 'multiline', mode: ['properties', 'create', 'edit'],
          disabled: 'inSchema'
        },{
          id: 'attacl', label: 'Privileges', type: 'collection',
          group: '{{ _('Security') }}', control: 'unique-col-collection',
          model: pgAdmin.Browser.Node.PrivilegeRoleModel.extend({
          privileges: ['a','r','w','x']}),
          mode: ['properties', 'edit'], canAdd: true, canDelete: true,
          uniqueCol : ['grantee']
        },{
          id: 'attoptions', label: 'Variables', type: 'collection',
          group: '{{ _('Security') }}', control: 'unique-col-collection',
          model: VariablesModel, uniqueCol : ['name'],
          mode: ['edit', 'create'], canAdd: true, canEdit: false,
          canDelete: true
        },{
          id: 'seclabels', label: '{{ _('Security Labels') }}',
          model: SecurityModel, editable: false, type: 'collection',
          group: '{{ _('Security') }}', mode: ['edit', 'create'],
          min_version: 90200, canAdd: true,
          canEdit: false, canDelete: true, control: 'unique-col-collection'
        }
        ],
        validate: function() {
          var err = {},
              changedAttrs = this.changed,
              msg = undefined;
          this.errorModel.clear();

          if (_.has(changedAttrs,this.get('name'))
                    && _.isUndefined(this.get('name'))
              || String(this.get('name')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Name can not be empty!') }}';
            this.errorModel.set('name', msg);
            return msg;
          } else if (_.has(changedAttrs,this.get('attowner'))
                        && _.isUndefined(this.get('attowner'))
              || String(this.get('attowner')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Schema can not be empty!') }}';
            this.errorModel.set('attowner', msg);
            return msg;
          } else if (_.has(changedAttrs,this.get('attowner'))
                        && _.isUndefined(this.get('attowner'))
              || String(this.get('attowner')).replace(/^\s+|\s+$/g, '') == '') {
            msg = '{{ _('Owner can not be empty!') }}';
            this.errorModel.set('attowner', msg);
            return msg;
          } else if (_.has(changedAttrs,this.get('attlen'))
                        && _.isUndefined(this.get('attlen'))
              || String(this.get('attlen')).replace(/^\s+|\s+$/g, '') == '') {
            // Validation for Length field
            if (this.get('attlen') < this.get('min_val'))
              msg = _("Length should not be less than " + this.get('min_val'))
            if (this.get('attlen') > this.get('max_val'))
              msg = _("Length should not be greater than " + this.get('max_val'))
            // If we have any error set then throw it to user
            if(msg) {
              this.errorModel.set('attlen', msg)
              return msg;
            }
           } else if (_.has(changedAttrs,this.get('attprecision'))
                        && _.isUndefined(this.get('attprecision'))
              || String(this.get('attprecision')).replace(/^\s+|\s+$/g, '') == '') {
            // Validation for precision field
            if (this.get('attprecision') < this.get('min_val'))
              msg = _("Precision should not be less than " + this.get('min_val'))
            if (this.get('attprecision') > this.get('max_val'))
              msg = _("Precision should not be greater than " + this.get('max_val'))
            // If we have any error set then throw it to user
            if(msg) {
              this.errorModel.set('attprecision', msg)
              return msg;
            }
            return null;
           }
        },
        // We will check if we are under schema node & in 'create' mode
        inSchema: function() {
          if(this.node_info &&  'catalog' in this.node_info)
          {
            return true;
          }
          return false;
        },
        // We will check if we are under schema node & in 'create' mode
        inSchemaWithModelCheck: function(m) {
          if(this.node_info &&  'schema' in this.node_info)
          {
            // We will disable control if it's in 'edit' mode
            if (m.isNew()) {
              return false;
            } else {
              return true;
            }
          }
          return true;    
        },
        // Checks weather to enable/disable control
        inSchemaWithColumnCheck: function(m) {
          if(this.node_info &&  'schema' in this.node_info)
          {
            // We will disable control if it's system columns
            // ie: it's position is less then 1
            if (m.isNew()) {
              return false;
            } else {
              // if we are in edit mode
              if (!_.isUndefined(m.get('attnum')) && m.get('attnum') >= 1 ) {
                return false;
              } else {
                return true;
              }
           }
          }
          return true;
        }
      }),
      // Below function will enable right click menu for creating column
      canCreate: function(itemData, item, data) {
          // If check is false then , we will allow create menu
          if (data && data.check == false)
            return true;

          var t = pgBrowser.tree, i = item, d = itemData, parents = [];
          // To iterate over tree to check parent node
          while (i) {
            // If it is schema then allow user to c reate table
            if (_.indexOf(['schema'], d._type) > -1)
              return true;
            parents.push(d._type);
            i = t.hasParent(i) ? t.parent(i) : null;
            d = i ? t.itemData(i) : null;
          }
          // If node is under catalog then do not allow 'create' menu
          if (_.indexOf(parents, 'catalog') > -1) {
            return false;
          } else {
            return true;
          }
      }
  });
 }

  return pgBrowser.Nodes['column'];
});
