/*
 * vkBytea.c
 *		Internal types to bytea for PostgreSQL.
        Vladimir Kokovic Belgrade YU
        vladakk@eunet.yu, vladakk@alcoyu.co.yu
 */

#include <postgres.h>
#include <fmgr.h>
#include <date.h>
#include <ctype.h>

#include "vkBytea.h"

/* SQL function: bint2(int2) returns bytea */
PG_FUNCTION_INFO_V1( pg_bint2 );

Datum pg_bint2( PG_FUNCTION_ARGS ) {

	int16	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL(0) )
		PG_RETURN_NULL();
	len = sizeof(int16);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_INT16( 0 );
	*((int16 *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bint4(int4) returns bytea */
PG_FUNCTION_INFO_V1( pg_bint4 );

Datum pg_bint4( PG_FUNCTION_ARGS ) {

	int32	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(int32);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_INT32( 0 );
	*((int32 *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bint8(int8) returns bytea */
PG_FUNCTION_INFO_V1( pg_bint8 );

Datum pg_bint8( PG_FUNCTION_ARGS ) {

	int64	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(int64);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_INT64( 0 );
	*((int64 *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bfloat4(float4) returns bytea */
PG_FUNCTION_INFO_V1( pg_bfloat4 );

Datum pg_bfloat4( PG_FUNCTION_ARGS ) {

	float4	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(float4);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_FLOAT4( 0 );
	*((float4 *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bfloat8(float8) returns bytea */
PG_FUNCTION_INFO_V1( pg_bfloat8 );

Datum pg_bfloat8( PG_FUNCTION_ARGS ) {

	float8	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(float8);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_FLOAT8( 0 );
	*((float8 *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: btext(text) returns bytea */
PG_FUNCTION_INFO_V1( pg_btext );

Datum pg_btext( PG_FUNCTION_ARGS ) {

	text	   *arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	arg = PG_GETARG_TEXT_P( 0 );
	len = VARSIZE( arg ) - VARHDRSZ;
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	memcpy( VARDATA( res ), VARDATA( arg ), len);
	PG_FREE_IF_COPY( arg, 0 );
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bvarchar(varchar) returns bytea */
PG_FUNCTION_INFO_V1( pg_bvarchar );

Datum pg_bvarchar( PG_FUNCTION_ARGS ) {

	VarChar	   *arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	arg = PG_GETARG_VARCHAR_P( 0 );
	len = VARSIZE( arg ) - VARHDRSZ;
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	memcpy( VARDATA( res ), VARDATA( arg ), len);
	PG_FREE_IF_COPY( arg, 0 );
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: bdate(date) returns bytea */
PG_FUNCTION_INFO_V1( pg_bdate );

Datum pg_bdate( PG_FUNCTION_ARGS ) {

	DateADT	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(DateADT);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_DATEADT( 0 );
	*((DateADT *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

/* SQL function: btime(time) returns bytea */
PG_FUNCTION_INFO_V1( pg_btime );

Datum pg_btime( PG_FUNCTION_ARGS ) {

	TimeADT	    arg;
	unsigned	len;
	bytea	   *res;

	if ( PG_ARGISNULL( 0 ) )
		PG_RETURN_NULL();
	len = sizeof(TimeADT);
	res = (text *)palloc( len + VARHDRSZ );
	VARATT_SIZEP( res ) = len + VARHDRSZ;
	arg = PG_GETARG_TIMEADT( 0 );
	*((TimeADT *)VARDATA( res )) = arg;
	PG_RETURN_BYTEA_P( res );

}

