DROP TABLE IF EXISTS repro_02;
DROP TABLE IF EXISTS repro_02_ref;

CREATE TABLE repro_02_ref (id serial PRIMARY KEY, t text NOT NULL UNIQUE);
INSERT INTO repro_02_ref (t) VALUES ('one');
INSERT INTO repro_02_ref (t) VALUES ('two');
INSERT INTO repro_02_ref (t) VALUES ('three');
INSERT INTO repro_02_ref (t) VALUES ('four');
INSERT INTO repro_02_ref (t) VALUES ('five');
INSERT INTO repro_02_ref (t) VALUES ('six');
INSERT INTO repro_02_ref (t) VALUES ('seven');
INSERT INTO repro_02_ref (t) VALUES ('eight');
INSERT INTO repro_02_ref (t) VALUES ('nine');
INSERT INTO repro_02_ref (t) VALUES ('ten');

CREATE TABLE repro_02 (
  id serial PRIMARY KEY,
  ref int NOT NULL REFERENCES repro_02_ref(id),
  t text NOT NULL DEFAULT 'xyz');

CREATE OR REPLACE FUNCTION repro_02_fill(tab text, rows integer, lim integer) RETURNS text AS $$
DECLARE
  result text;
  count integer := 0;
  stmt text := 'INSERT INTO ' || tab || ' (ref) VALUES (ceil(random() * ' || lim || '))';
BEGIN
  LOOP
    EXIT WHEN count >= rows;
    EXECUTE stmt;
    --INSERT INTO repro_02 (ref, t) VALUES (ceil(random() * 5), 'xyz');
    count := count + 1;
  END LOOP;
  RETURN 'Inserted ' || count || ' rows into ' || tab;
END
$$ LANGUAGE plpgsql;

SELECT repro_02_fill('repro_02', 10000, 10);
