#!/usr/bin/env jruby

class Array
  def random
    self[rand(self.size)]
  end
end

CONTACT_TYPE = %W[BOSS EMP FRND PRSNL WORK]
LASTNAME = %W[Becker Adams Johnson Smith Trent Hallman Frame Michael Chang Klinger Gonzales]
FIRSTNAME = %W[Alan Joe John Brian Roy Sam Christina Diane Frank Byron Pan Julie Nicky Nick Terry George]
MIDDLENAME = %W[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z]
DOMAIN = ["yahoo.com", "gmail.com", "msn.com", "test.com", "juno.com", "cfl.rr.com"]
ADDRESS1 = ["Pinetree Dr.", "Test St.", "United Dr.", "Happy St."]
CITY = ["Orlando", "Melbourne", "Satellite Beach", "Tampa", "Jacksonville", "Miami"]
ZIP_CODE = %W[32937 32935 32765 32817 32738 32271 32912]

File.open("/tmp/contacts", "w") do |fout|
  250_000.times do |index|
    contactid = index + 1
    
    lname = LASTNAME.random
    fname = FIRSTNAME.random
    domain = DOMAIN.random
    email = sprintf("%s.%s@%s", fname.downcase, lname.downcase, domain)
    
    address1 = ADDRESS1.random
    
    fout << contactid << "\t" # id
    fout << CONTACT_TYPE.random << "\t" # contact_type_code
    fout << lname << "\t" # lname
    fout << fname << "\t" # fname
    fout << MIDDLENAME.random << "\t" # mname
    fout << email << "\t" # email
    fout << sprintf("%d %s", index * 31, address1) << "\t" # address1
    fout << "\\N" << "\t" # address2
    fout << CITY.random << "\t" # city
    fout << "FL" << "\t" # state
    fout << ZIP_CODE.random << "\t" # zip_code
    fout << rand(20_000) + 1 << "\t" # user_id
    fout << "2010-01-22 13:32:12" << "\n" # created_date
    
    puts "Created #{index} contacts" if index % 100 == 0
  end
end