#include "varchar.h"

/* "True" length (not counting trailing blanks) of a BpChar */
int
bcTruelen1(BpChar *arg)
{
	char	   *s = VARDATA_ANY(arg);
	int			i;
	int			len;

	len = VARSIZE_ANY_EXHDR(arg);
	for (i = len - 1; i >= 0; i--)
	{
		if (s[i] != ' ')
			break;
	}
	return i + 1;
}

/* "True" length (not counting trailing blanks) of a BpChar */
int
bcTruelen2(BpChar *arg)
{
	const unsigned int spaces = 0x20202020;
	const int	wordsize = sizeof(spaces);
	char	   *s = VARDATA_ANY(arg);
	int			i;

	i = VARSIZE_ANY_EXHDR(arg) - 1;

	/* compare down to an aligned boundary */
	for (; i >= 0 && ((unsigned long)(s+i)) % wordsize != wordsize - 1; i--)
	{
		if (s[i] != ' ')
			return i + 1;
	}

	/* now that we're aligned, compare word at a time */
	for (; i >= wordsize - 1; i -= wordsize)
	{
		if (*(unsigned int *)(s + i - (wordsize - 1)) != spaces)
			break;
	}

	/* check within the last non-matching word */
	for (; i >= 0; i--)
	{
		if (s[i] != ' ')
			break;
	}

	return i + 1;
}

/*
 * "True" length (not counting trailing blanks) of a BpChar
 */
int
bcTruelen3(BpChar *arg)
{
	char		   *s = VARDATA_ANY(arg);
	char		   *p;
	const uint32	spaces = 0x20202020L;
	int				len;
	char			sentinel;

	len = VARSIZE_ANY_EXHDR(arg);
	--s;							/* Point to where sentinel will be */
	if (*s != ' ')					/* Do I have a sentinel? */
	{
		p = s + len + 1;			/* Point to end of data. */

		/* Handle any bytes needed to get pointer word aligned. */
		while(((unsigned long) p) & (sizeof(spaces)-1))
		{
			--p;
			if (*p != ' ')
				return p-s;
		}
	
		/* Process a word at a time until non-space found */
		do
		{
			p -= sizeof(spaces);
		} while(*((unsigned int *)p) == spaces);

		/* Now process those bytes to find the space. */
		p += sizeof(spaces) - 1;

		while(*p == ' ')
			--p;
	}
	else
	{
		p = s + len + 1;			/* Point to end of data. */

		/* Handle any bytes needed to get pointer word aligned. */
		while(((unsigned long) p) & (sizeof(spaces)-1) && p > s)
		{
			--p;
			if (*p != ' ')
				return p-s;
		}
	
		/* Process a word at a time until non-space found */
		do
		{
			p -= sizeof(spaces);
		} while(p>s && *((uint32 *)p) == spaces);

		/* Now process those bytes to find the space. */
		p += sizeof(spaces) - 1;

		while(*p == ' ' && p > s)
			--p;

	}
	return p-s;		/* Return length */
}

/*
 * "True" length (not counting trailing blanks) of a BpChar
 */
int
bcTruelen4(BpChar *arg)
{
	char	*s;
	char	*p;

	if (VARATT_IS_1B(arg))
	{	/* No need to worry about sentinel. 1B headers can never have value of 0x20 */
		s = (void *)arg;
		p = s + VARSIZE_1B(arg);
		do
			--p;
		while(*p == ' ');
	}
	else
	{
		s = VARDATA_4B(arg);
		p = s + VARSIZE_4B(arg)-VARHDRSZ;
		--s;						/* Point to where sentinel will be */

		if (*s != ' ')				/* Suitable sentinel? */
		{							/* Yep, do it. */
			do
				--p;
			while(*p == ' ');
		}
		else
		{							/* No sentinel available. */
			if (*((uint32 *)arg) != 0x20202020) {	/* Can I go a little out of bounds? */
				do					/* Yep. Do it. Then see how naughty I was later */
					--p;
				while(*p == ' ');
				if (p < s)			/* Shame on me. Went too far. But easy to fix. */
					p = s;
			}
			else
			{						/* Sigh.... Do it the slow way. */
				do
					--p;
				while(*p == ' ' && p > s);
			}
		}
	}

	return p-s;			/* Return length */
}

int
bcNop(BpChar *arg)
{
   return 0;
}
