/*-------------------------------------------------------------------------
 *
 * xidtest.c
 *
 * Copyright (c) 2012, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *	  contrib/xidtest/xidtest.c
 *
 *-------------------------------------------------------------------------
 */

#include "postgres.h"

#include "access/htup.h"
#include "access/transam.h"
#include "access/xact.h"
#include "funcapi.h"

PG_MODULE_MAGIC;

Datum		consume_xids(PG_FUNCTION_ARGS);
Datum		print_xidlsnranges(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(consume_xids);
PG_FUNCTION_INFO_V1(print_xidlsnranges);

Datum
consume_xids(PG_FUNCTION_ARGS)
{
	int32		nxids = PG_GETARG_INT32(0);
	int32		total = nxids;

	(void) GetTopTransactionId();
	
	while (nxids > 0)
	{
		TransactionId nextXid;

		LWLockAcquire(XidGenLock, LW_EXCLUSIVE);
		nextXid = ShmemVariableCache->nextXid;
		if ((nextXid % 1024) > 10 && (nextXid % 1024) < 1010)
		{
			int increment = 1010 - (nextXid % 1024);
			if (increment > nxids)
				increment = nxids;
			ShmemVariableCache->nextXid += increment;
			nxids -= increment;
			LWLockRelease(XidGenLock);
		}
		else
		{
			LWLockRelease(XidGenLock);
			GetNewTransactionId(false);
			nxids--;
		}		
	}
	
	elog(NOTICE, "consumed %d xids, nextXid = %u", total, (unsigned int) ReadNewTransactionId());
	
	PG_RETURN_VOID();
}

Datum
print_xidlsnranges(PG_FUNCTION_ARGS)
{
	int i;
	XLogRecPtr pageMatureLSN;

	LWLockAcquire(XidGenLock, LW_EXCLUSIVE);
	
	for (i = 0; i < ShmemVariableCache->numranges; i++)
	{
		XidLSNRange *range = &ShmemVariableCache->xidlsnranges[i];
		elog(NOTICE, "XIDs %u - %u, MultiXIDs %u - %u, LSN %X/%X (expires %u)",
			 range->minxid, range->maxxid,
			 range->minmxid, range->maxmxid,
			 (uint32) (range->beginlsn >> 32), (uint32) (range->beginlsn),
			range->expirationXmin);
	}
	LWLockRelease(XidGenLock);

	LWLockAcquire(ProcArrayLock, LW_SHARED);
	pageMatureLSN = ShmemVariableCache->pageMatureLSN;
	LWLockRelease(ProcArrayLock);
	elog(NOTICE, "page mature LSN %X/%X",
				 (uint32) (pageMatureLSN >> 32),
				 (uint32) (pageMatureLSN));
	
	PG_RETURN_VOID();
}
