/*-------------------------------------------------------------------------
 *
 * example.c
 *	  Quick and dirty hack
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_ext.h"

#include <sys/stat.h>
#include <fcntl.h>
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif

#include "libpq-fe.h"

#define USE_PREPARED_STATEMENT 2

int
main(int argc, char **argv)
{
	PGconn	   *conn;
#if USE_PREPARED_STATEMENT != 0
	PGresult   *resprepare;
#endif
    PGresult   *resexecute;
    int row, col;
    char *tmp;

    conn = PQconnectdb("host=localhost dbname=example");
	if (!conn)
	{
		fprintf(stderr, "Connection to database failed\n");
		return -1;
	}

	if (PQstatus(conn) == CONNECTION_BAD)
	{
		fprintf(stderr, "Connection to database failed:\n%s", PQerrorMessage(conn));
		PQfinish(conn);
		return -1;
	}

    printf ("connection OK\n");

#if USE_PREPARED_STATEMENT == 1
    resprepare = PQprepare(conn, "test", "DELETE FROM v1 WHERE c1 BETWEEN 10 AND 90 RETURNING c1, deleted", 0, NULL);
	if (PQresultStatus(resprepare) != PGRES_COMMAND_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resprepare));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resprepare);
		PQfinish(conn);
		return -1;
	}

    printf ("prepare OK\n");

    resexecute =  PQexecPrepared(conn, "test", 0, NULL, NULL, NULL, 0);
	if (PQresultStatus(resexecute) != PGRES_TUPLES_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resexecute));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resexecute);
		PQfinish(conn);
		return -1;
	}
#elif USE_PREPARED_STATEMENT == 2
    resprepare = PQexec(conn, "PREPARE test AS DELETE FROM v1 WHERE c1 BETWEEN 10 AND 90 RETURNING c1, deleted");
	if (PQresultStatus(resprepare) != PGRES_COMMAND_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resprepare));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resprepare);
		PQfinish(conn);
		return -1;
	}

    printf ("prepare OK\n");

    resexecute =  PQexec(conn, "EXECUTE test");
	if (PQresultStatus(resexecute) != PGRES_TUPLES_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resexecute));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resexecute);
		PQfinish(conn);
		return -1;
	}
#else
    resexecute =  PQexec(conn, "DELETE FROM v1 WHERE c1 BETWEEN 10 AND 90 RETURNING c1, deleted");
	if (PQresultStatus(resexecute) != PGRES_TUPLES_OK)
	{
		fprintf(stderr, "Failed to execute (%d):\n", PQresultStatus(resexecute));
		fprintf(stderr, "%s", PQerrorMessage(conn));
		PQclear(resexecute);
		PQfinish(conn);
		return -1;
	}
#endif

    printf ("execute OK\n");

    printf ("ntuples: %d\n", PQntuples(resexecute));

    for (row=0; row<10; row++)
    {
        for (col=0; col<2; col++)
        {
            tmp = PQgetvalue(resexecute, row, col);
            printf("(%d,%d) = %s\n", row, col, tmp);
        }
    }

#if USE_PREPARED_STATEMENT != 0
	PQclear(resprepare);
#endif
	PQclear(resexecute);
	PQfinish(conn);

    printf ("cleanup OK\n");

    return 0;
}
