-- setup:
create table a(foo int primary key);
create table b(i int primary key, foo int references a);

create function test_eelog_performance()
returns void as $$
declare
-- With the patch:
-- postgres=# insert into b values(4,4);
-- ERROR:  23503: insert or update on table "b" violates foreign key constraint "b_foo_fkey"
-- DETAIL:  Key (foo)=(4) is not present in table "a".
-- LOCATION:  ri_ReportViolation, ri_triggers.c:3228
-- TABLE NAME:  b
-- SCHEMA NAME:  public
-- CONSTRAINT NAME:  b_foo_fkey
-- CONSTRAINT SCHEMA:  public
begin
	insert into b values(4,4);
exception when others then
	null;	
end;
$$ language plpgsql;
