#!/usr/bin/perl
use strict;
use warnings;

use DBI;
use DBD::Pg;
use Digest::SHA1 qw(sha1_hex);
use File::Slurp qw(write_file);

my %digraphs;
open my $log_file, '<', $ARGV[0] or die "Could not open file because $!";
while (my $log_row = <$log_file>) {
    if ($log_row =~ m/(digraph {[0-9;>-]+})/) {
        my $digraph = $1;
        if (!exists $digraphs{$digraph}) {
            $digraphs{$digraph} = 1;
        }
    }
}
close $log_file;

my $dbh = DBI->connect('dbi:Pg:dbname=test', 'joel', '', {RaiseError => 1}) or die "Unable to connect because $!";

my $sth = $dbh->prepare("SELECT oid, proname FROM pg_proc") or die "Unable to prepare";
$sth->execute() or die "Unable to execute";
my $rows = $sth->fetchall_arrayref();
my %oids;
foreach my $row (@$rows) {
    $oids{$row->[0]} = $row->[1];
}

foreach my $digraph (sort keys %digraphs) {
    foreach my $oid (keys %oids) {
        while ($digraph =~ s/([{};>-])$oid([{};>-])/$1$oids{$oid}$2/g) {};
    }
    print "$digraph\n";
    my $hash = sha1_hex($digraph);
    unless (-e "$hash.dot") {
        write_file("$hash.dot", $digraph);
        `dot -o$hash.png -Tpng $hash.dot`;
    }
}
