<?php

$tables = array(
  'test1', 'test2', 'test3'
);

$countPerSize = 100;
$sizes = array(1000);

/*
 * Database connection options.
 */
$dbConnString = 'pgsql:host=localhost;dbname=test;port=5431';
$dbUsername = 'smagen';
$dbPassword = '';

function getBox($tableName, $center, $count)
{
  global $con;
  $left = 0;
  $right = null;
  while (is_null($right) || ($right - $left > 0.001))
  {
    if (is_null($right))
    {
      if ($left > 0)
        $range = 2 * $left;
      else
        $range = 1;
    }
    else
      $range = ($left + $right) / 2.0;
    $box = array(
      'x1' => $center['x'] - $range * 0.5,
      'x2' => $center['x'] + $range * 0.5,
      'y1' => $center['y'] - $range * 0.5,
      'y2' => $center['y'] + $range * 0.5
    );
    $result = $con->query($q = '
      SELECT 
        count(*) AS cnt
      FROM
        ' . $tableName . '
      WHERE
        box(point(x1,y1),point(x2,y2)) @ 
        \'('.$box['x1'].', '.$box['y1'].'),('.$box['x2'].', '.$box['y2'].')\'::box
    ');
    $row = $result->fetch(PDO::FETCH_ASSOC);
    $box['count'] = $row['cnt'];
    if ($row['cnt'] == $count)
    {
      break;
    }
    if ($row['cnt'] < $count)
    {
      $left = $range;
    }
    if ($row['cnt'] > $count)
    {
      $right = $range;
    }
  }
  return $box;
}

/*
 * Connect to the test database.
 */
$con = new PDO($dbConnString, $dbUsername);

/*
 * Prepared statement for new test information insertion.
 */
$testInsert = $con->prepare('
  INSERT INTO tests
  (
    tablename,
    x1,
    y1,
    x2,
    y2,
    count,
    nominal_count
  )
  VALUES
  (
    :tableName,
    :x1,
    :y1,
    :x2,
    :y2,
    :count,
    :nominalCount
  );
');

$totalCount = $countPerSize * count($sizes);

foreach ($tables as $tableName)
{
  echo "Table $tableName\n";
  $centers = array();
  $result = $con->query('
    SELECT 
      x1, y1, x2, y2
    FROM
      ' . $tableName . '
    ORDER BY
      random()
    LIMIT
      ' . $totalCount . '
  ');
  while ($row = $result->fetch(PDO::FETCH_ASSOC))
  {
    $centers []= array(
      'x' => ($row['x1'] + $row['x2']) / 2.0,
      'y' => ($row['y1'] + $row['y2']) / 2.0
    );
  }
  $centerIndex = 0;
  foreach ($sizes as $size)
  {
    echo "Size = $size\n";
    for ($i = 0; $i < $countPerSize; $i++)
    {
      echo "i = $i\n";
      $box = getBox($tableName, $centers[$centerIndex], $size);
      $box['tableName'] = $tableName;
      $box['nominalCount'] = $size;
      $testInsert->execute($box);
      $centerIndex++;
    }
  } 
}
