<?php

$tables = array(
  'test1', 'test2', 'test3'
);

$strategies = array(1, 2);

/*
 * Database connection options.
 */
$dbConnString = 'pgsql:host=localhost;dbname=test;port=5431';
$dbUsername = 'smagen';
$dbPassword = '';

/**
 * Returns number of IOs during query execution.
 * 
 * @global PDO $con Соединение с БД
 * @param string $query Запрос
 * @return integer
 */
function getHitsCount($query)
{
  global $con;
  /* Get plan of query execution in JSON format */
  $result = $con->query('EXPLAIN (ANALYZE, BUFFERS, FORMAT JSON) ' . $query);
  if (!$result)
  {
    echo $query;
    exit(1);
  }
  $row = $result->fetch(PDO::FETCH_NUM);
  
  /* Decoding JSON */
  $explain = json_decode($row[0], true);
  $plan = $explain[0]['Plan'];
  
  /* Find element of index scan */
  if (isset($plan['Plans'][0]))
  {
    $plan = $plan['Plans'][0];
    $hits = $plan['Shared Hit Blocks'];
    $hits += $plan['Shared Read Blocks'];
  }
  else
  {
    $hits = $plan['Shared Hit Blocks'];
    $hits += $plan['Shared Read Blocks'];
  }
  return $hits;
}

/*
 * Connect to the test database.
 */
$con = new PDO($dbConnString, $dbUsername);

/*
 * Load 'plantuner' module.
 */
$con->exec('LOAD \'plantuner\';');

/*
 * Prepared statement for new test information insertion.
 */
$testInsert = $con->prepare('
  INSERT INTO test_results
  (
    tablename,
    count,
    nominal_count,
    hits,
    strategy
  )
  VALUES
  (
    :tablename,
    :count,
    :nominal_count,
    :hits,
    :strategy
  );
');

foreach ($tables as $tablename)
{
  echo "Table $tablename\n";
  $tests = array();
  $result = $con->query('
    SELECT
      *
    FROM
      tests
    WHERE
      tablename = \'' . $tablename . '\'
  ');
  while ($row = $result->fetch(PDO::FETCH_ASSOC))
  {
    $tests []= $row;
  }
  
  foreach($strategies as $strategy)
  {
    $forbidIndexes = array();
    $forbidStrategies = $strategies;
    foreach ($forbidStrategies as $forbidStrategy)
    {
      if ($forbidStrategy != $strategy)
      {
        $forbidIndexes []= $tablename.'_idx'.$forbidStrategy;
      }
    }
    $con->exec('SET plantuner.forbid_index=\''. implode(',', $forbidIndexes) .'\';');
    
    echo "Strategy $strategy\n";
    foreach ($tests as $test)
    {
      $query = '
        SELECT
          *
        FROM
          ' . $tablename . '
        WHERE
          box(point(x1,y1),point(x2,y2)) <@ 
          box(point(' . $test['x1'] . ', ' . $test['y1'] . '), point(' . $test['x2'] . ', ' . $test['y2'] . '))';
      $hits = getHitsCount($query);
      $testInsert->execute(array(
        'tablename'     => $tablename,
        'count'         => $test['count'],
        'nominal_count' => $test['nominal_count'],
        'hits'          => $hits,
        'strategy'      => $strategy
      ));
    }
  }  
}
