-- unique indexes
create table gfoo(x int);

create table gbar(y int) inherits (gfoo);

create global unique index gfoox on gfoo(x);

insert into gfoo values (1);

-- err
insert into gbar values (1,1);

drop index gfoox;

insert into gbar values (1,1);

-- err
create global unique index gfoox on gfoo(x);

delete from gbar;

create table  gc1(c1 int) inherits (gfoo);

insert into gc1 values (2,1);

insert into gbar values (2,2);

-- err bar vs c1
create global unique index gfoox on gfoo(x);

delete from gbar;

create global unique index gfoox on gfoo(x);

-- err bar vs c1
insert into gbar values (2,2);

drop index gfoox;

delete from gbar;

create table gbarc1(y int, bc1 int, x int);

insert into gbarc1 values (3,1,2);

alter table gbarc1 inherit gbar;

-- err gbarc1 vs c1
create global unique index gfoox on gfoo(x);

delete from gbarc1;

create global unique index gfoox on gfoo(x);

-- err gbarc1 vs c1
insert into gbarc1 values (3,1,2);


-- cleanup
drop table gfoo cascade;
------------------------------------------------------------
create table gfoo(x int);
create table gbar (y int) inherits (gfoo);

insert into gfoo values (1);
insert into gbar values (2,2);

-- uniqueness errors by update
create global unique index gfoox on gfoo (x);
update gfoo set x = 3;
update gbar set x = 1;
update only gfoo set x = 2;
drop index gfoox;

-- scans
create global index gfoox on gfoo (x);

set enable_seqscan to false;
set enable_bitmapscan to false;

-- all rows
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-- no rows
explain select * from gfoo where x < 0 order by x;
select * from gfoo where x < 0 order by x;

explain select * from gbar where x < 0 order by x;
select * from gbar where x < 0 order by x;

-- some rows
insert into gfoo values (3);
insert into gbar values (3,3);
explain select * from gbar where x = 0 order by x;
select * from gbar where x = 0 order by x;

-- check bitmap scans
set enable_bitmapscan to true;
set enable_indexscan to false;

explain select * from gbar where x = 2 or x = 3;
select * from gbar where x = 2 or x = 3;

-- bitmap with another index
create index gbary on gbar (y);

-- a row
explain select * from gbar where x = 2 and y = 2;
select * from gbar where x = 2 and y = 2;

-- no rows
explain select * from gbar where x = 2 and y = 3;
select * from gbar where x = 2 and y = 3;

-- or
explain select * from gbar where x = 2 or y = 3;
select * from gbar where x = 2 or y = 3;
--------------------------------------------------------------
-- updates
-- HOT update
-- checkpoint for data
select * from gfoo;
select * from gbar;

drop index gbary;
update gbar set y= 5;

-- check index scan
set enable_bitmapscan to false;
set enable_indexscan to true;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-- check bitmap scan
set enable_bitmapscan to true;
set enable_indexscan to false;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;


-- cold update
explain update gfoo set x = 10 where x = 3;
update gfoo set x = 10 where x = 3;

-- check index scan
set enable_bitmapscan to false;
set enable_indexscan to true;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-- check bitmap scan
set enable_bitmapscan to true;
set enable_indexscan to false;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-------------------------------------------------------
-- deletes
delete from gfoo where x =10;

-- check index scan
set enable_bitmapscan to false;
set enable_indexscan to true;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-- check bitmap scan
set enable_bitmapscan to true;
set enable_indexscan to false;

explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;
--------------------------------------------------------
-- Miscellany

-- data checkpoint
select * from gfoo;
select * from gbar;

-- using only index scans...
set enable_bitmapscan to false;
set enable_indexscan to true;

-- check new children are adopted
create table barc1 (z int) inherits (gbar);
insert into barc1 values (5,5,5);
explain select * from gbar where x > 0 order by x;
select * from gbar where x > 0 order by x;

-- another adoption check; uniqueness
create global unique index gfoox2 on gfoo(x);
create table fooc1 (a int) inherits (gfoo);

-- err conflicts with barc1
insert into fooc1 values (5,5);

insert into fooc1 values (10, 10);

drop index gfoox2;
-- check removing children
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from fooc1 where x > 0 order by x;
select * from fooc1 where x > 0 order by x;

-- first, by alter table no inherit
alter table fooc1 no inherit gfoo;
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

explain select * from fooc1 where x > 0 order by x;
select * from fooc1 where x > 0 order by x;

drop table fooc1;

-- next, by dropping a child
drop table barc1;
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

-- just add a table again...
create table barc1(z int) inherits (gbar);
insert into barc1 values (5,5,5);
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

-- and now abolish all children
drop table gbar cascade;
explain select * from gfoo where x > 0 order by x;
select * from gfoo where x > 0 order by x;

-- cleanup
drop table gfoo cascade;

-- alter table add inherit disallowed for global index
create table gfoo (x int);
create table gbar (x int, y int);
create global index foox on gfoo (x);
alter table gbar inherit gfoo;

drop index foox;
alter table gbar inherit gfoo;

-- cleanup
drop table gfoo cascade;
--------------------------------------------------------------
-- expression-based index
create table gfoo(x int, y int);
create table gbar () inherits (gfoo);
insert into gfoo values (1,2);
insert into gbar values (2,1);

create global unique index foosum on gfoo ((x + y));
delete from gbar;

create global unique index foosum on gfoo ((x + y));
insert into gbar values (2,1); --err

insert into gbar values (-1,1);

create global unique index fooxabs on gfoo ((abs(x)));
delete from gbar;

create global unique index fooxabs on gfoo ((abs(x)));
insert into gbar values (-1,1); -- err

insert into gbar values (3,0); --err
insert into gbar values (3,3);

set enable_seqscan to false;
set enable_bitmapscan to false;

explain select * from gfoo where (x + y) > 0 order by (x + y);
select * from gfoo where (x + y) > 0 order by (x + y);

explain select * from gbar where (x + y) > 0 order by (x + y);
select * from gbar where (x + y) > 0 order by (x + y);

drop table gfoo cascade;
----------------------------------
-- partial indexes
create table gfoo(x int, y int);
create table gbar () inherits (gfoo);

insert into gfoo values (1,1);
insert into gbar values (1,2);

create global unique index fooxp on gfoo(x) where y > 0;

delete from gbar;
create global unique index fooxp on gfoo(x) where y > 0;
insert into gbar values (1,2);

insert into gbar values (1,0);
insert into gbar values (2,2);

explain select * from gfoo where y > 0;
select * from gfoo where y > 0;

drop table gfoo cascade;
-------------------------------------------------------------
-- stats
create table gfoo (x int);
create table gbar (y int) inherits (gfoo);

insert into gfoo values (1);
insert into gfoo values (2);
insert into gbar values (1,1);

select relname, reltuples from pg_class 
where relname in ('gfoo','gbar')
order by relname;

create global index foox on gfoo (x);
select relname, reltuples from pg_class 
where relname in ('gfoo','gbar','foox')
order by relname;

create index fooxn on gfoo (x);
create index barxn on gbar (x);

select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox','gfoo','gbar')
order by relname;

-- reindex
delete from gfoo;

reindex table gfoo;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox','gfoo','gbar')
order by relname;

reindex table gbar;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox','gfoo','gbar')
order by relname;

reindex index foox;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox','gfoo','gbar')
order by relname;

drop table gfoo cascade;

-- truncate
create table gfoo (x int);
create table gbar (y int) inherits (gfoo);

insert into gfoo values (1);
insert into gbar values (1,1);

create index fooxn on gfoo (x);
create index barxn on gbar (x);
create global index foox on gfoo (x);

select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox')
order by relname;

truncate gfoo;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox')
order by relname;

truncate gbar;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox')
order by relname;

reindex index foox;
select relname, reltuples from pg_class 
where relname in ('fooxn','barxn','foox')
order by relname;

-- cluster
cluster gfoo using foox;
cluster gbar using foox;

drop table gfoo cascade;
---------------------------------------------
set enable_seqscan to true;
set enable_bitmapscan to true;
set enable_indexscan to true;
---------------------------------------------
-- vacuum et.al.
create table gfoo (x int);
create table gbar () inherits (gfoo);
create global index gfoox on gfoo (x);
vacuum gbar;
select relhasindex from pg_class where relname = 'gbar';

insert into gfoo values (1);
insert into gbar values (2);
insert into gbar values (3);

drop index gfoox;
create global index gfoox on gfoo (x);
create index foox on gfoo(x);
create index barx on gbar(x);

select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

delete from gbar;
vacuum gfoo;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum gbar;
select reltuples, relname from pg_class
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

insert into gbar values (2);
insert into gbar values (3);
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum gbar;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

alter table gbar no inherit gfoo;
vacuum gbar;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum gfoo;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

drop table gfoo;
drop table gbar;

-- vacuum full; exact copy of vacuum above...
create table gfoo (x int);
create table gbar () inherits (gfoo);
create global index gfoox on gfoo (x);
vacuum full gbar;
select relhasindex from pg_class where relname = 'gbar';

insert into gfoo values (1);
insert into gbar values (2);
insert into gbar values (3);

drop index gfoox;
create global index gfoox on gfoo (x);
create index foox on gfoo(x);
create index barx on gbar(x);

select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

delete from gbar;
vacuum full gfoo;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum full gbar;
select reltuples, relname from pg_class
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

insert into gbar values (2);
insert into gbar values (3);
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum full gbar;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

alter table gbar no inherit gfoo;
vacuum full gbar;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

vacuum full gfoo;
select reltuples, relname from pg_class 
where relname in ('gfoo','gbar','gfoox','foox','barx')
order by relname;

drop table gfoo;
drop table gbar;

-- analyze; check that global indexes are not affected...
create table gfoo (x int);
create table gbar () inherits (gfoo);
create global index gfoox on gfoo (x);
analyze gbar;
select relhasindex from pg_class where relname = 'gbar';

insert into gfoo values (1);
insert into gbar values (2);
insert into gbar values (3);

drop index gfoox;
create global index gfoox on gfoo ((x*2));
create index foox on gfoo((x*2));
create index barx on gbar((x*2));

select count(*) from pg_statistic 
where starelid in ('gfoox'::regclass,'barx'::regclass,'foox'::regclass);

analyze gfoo;

select relname, count(*) 
from pg_statistic, pg_class 
where starelid = pg_class.oid and
starelid in ('gfoox'::regclass,'barx'::regclass,'foox'::regclass)
group by relname
order by relname;

analyze gbar;

select relname, count(*) 
from pg_statistic, pg_class 
where starelid = pg_class.oid and
starelid in ('gfoox'::regclass,'barx'::regclass,'foox'::regclass)
group by relname
order by relname;
drop table gfoo cascade;
