/*-------------------------------------------------------------------------
 *
 * wpfunctions.c
 *
 *
 * Copyright (c) 2008-2009, PostgreSQL Global Developent Group
 *
 * IDENTIFICATION
 *	  $PostgreSQL: pgsql/contrib/wpfunctions
 *
 * SELECT foo;
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "fmgr.h"

#include "catalog/namespace.h"
#include "nodes/nodeFuncs.h"
#include "parser/parse_expr.h"
#include "parser/parse_func.h"
#include "nodes/parsenodes.h"
#include "utils/elog.h"

Node * transformColumnRef(ParseState *pstate, Node *expr);

/* Saved hook value  */
static ParseExprTransform_hook_type	prev_transformExpr = NULL;

void	_PG_init(void);
void	_PG_fini(void);


PG_MODULE_MAGIC;

void
_PG_init(void)
{
	/* Install hooks. */
	prev_transformExpr = ParseExprTransform_hook;
	ParseExprTransform_hook = transformColumnRef;
}

/*
 * Module unload callback
 */
void
_PG_fini(void)
{
	/* Uninstall hooks. */
	ParseExprTransform_hook = prev_transformExpr;
}

/*
 * Basic rule - don't duplicate code, 
 *    transformation have to be transitive!!
 * 
 */
Node *
transformColumnRef(ParseState *pstate, Node *expr)
{
	/* 
	 * inside hook handler don't try to transform expr
	 */
	if (IsA(expr, ColumnRef))
	{
		Node *aux = NULL;
		FuncCall	*fn = NULL;
		ColumnRef	*cr = (ColumnRef *) expr;
		
		PG_TRY();
		{
			/* ColumnRef is ok, because don't try to transform subnodes */
			aux = standard_transformExpr(pstate, expr);
		}
		PG_CATCH();
		{
			Oid	funcid, rettype;
			bool	retset;
			int		nvargs;
			Oid		*true_typeids;
			FuncDetailCode		fdcode;
			
			fdcode = func_get_detail(cr->fields,
						    NIL, NIL, 0, NULL, false, false,
						    &funcid, &rettype, &retset, &nvargs, &true_typeids,
						    NULL, NULL, NULL);
						
			if (fdcode == FUNCDETAIL_NORMAL)
			{
				fn = (FuncCall *) makeNode(FuncCall);
				fn->funcname = cr->fields;
				fn->location = cr->location;
				fn->args = NIL;
				fn->agg_star = false;
				fn->agg_distinct = false;
				fn->func_variadic = false;
				fn->over = NULL;

				expr = (Node *) fn;
			}
		}
		PG_END_TRY();
	}

	if (prev_transformExpr)
		return prev_transformExpr(pstate, expr);
	else
		return standard_transformExpr(pstate, expr);
}

