/*-------------------------------------------------------------------------
 *
 * relpath.c
 *      Construct relation file path.
 *		This function was copied from src/backend/catalog/catalog.c.
 *
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *-------------------------------------------------------------------------
 */

#include "postgres.h"
#include "catalog/catalog.h"
#include "catalog/pg_tablespace.h"
#include "storage/relfilenode.h"

#define OIDCHARS	10			/* max chars printed by %u */

/*
 * relpath			- construct path to a relation's file
 *
 * Result is a malloc'd string.
 */
char *
relpath(RelFileNode rnode)
{
	int			pathlen;
	char	   *path;

	if (rnode.spcNode == GLOBALTABLESPACE_OID)
	{
		/* Shared system relations live in {datadir}/global */
		Assert(rnode.dbNode == 0);
		pathlen = 7 + OIDCHARS + 1;
		path = (char *) malloc(pathlen);
		if (!path)
		{
			printf("Can't allocate memory for path.\n");
			exit(1);
		}
		snprintf(path, pathlen, "global/%u",
				 rnode.relNode);
	}
	else if (rnode.spcNode == DEFAULTTABLESPACE_OID)
	{
		/* The default tablespace is {datadir}/base */
		pathlen = 5 + OIDCHARS + 1 + OIDCHARS + 1;
		path = (char *) malloc(pathlen);
		if (!path)
		{
			printf("Can't allocate memory for path.\n");
			exit(1);
		}
		snprintf(path, pathlen, "base/%u/%u",
				 rnode.dbNode, rnode.relNode);
	}
	else
	{
		/* All other tablespaces are accessed via symlinks */
		pathlen = 10 + OIDCHARS + 1 + OIDCHARS + 1 + OIDCHARS + 1;
		path = (char *) malloc(pathlen);
		if (!path)
		{
			printf("Can't allocate memory for path.\n");
			exit(1);
		}
		snprintf(path, pathlen, "pg_tblspc/%u/%u/%u",
				 rnode.spcNode, rnode.dbNode, rnode.relNode);
	}
	return path;
}

