/*-------------------------------------------------------------------------
 *
 * pg_readahead.h
 *		Common header file for the pg_readahead utility.
 *
 *
 * Portions Copyright (c) 2008, Nippon Telegraph and Telephone Corporation
 * Portions Copyright (c) 1996-2004, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_READAHEAD_H
#define PG_READAHEAD_H

static const char * const RM_names[RM_MAX_ID + 1] = {
	"XLOG ",					/* 0 */
	"XACT ",					/* 1 */
	"SMGR ",					/* 2 */
	"CLOG ",					/* 3 */
	"DBASE",					/* 4 */
	"TBSPC",					/* 5 */
	"MXACT",					/* 6 */
	"RM  7",					/* 7 */
	"RM  8",					/* 8 */
	"HEAP2",					/* 9 */
	"HEAP ",					/* 10 */
	"BTREE",					/* 11 */
	"HASH ",					/* 12 */
	"GIN",						/* 13 */
	"GIST ",					/* 14 */
	"SEQ  "						/* 15 */
};

/* XXX these ought to be in smgr.h, but are not */
#define XLOG_SMGR_CREATE	0x10
#define XLOG_SMGR_TRUNCATE	0x20

typedef struct xl_smgr_create
{
	RelFileNode rnode;
} xl_smgr_create;

typedef struct xl_smgr_truncate
{
	BlockNumber blkno;
	RelFileNode rnode;
} xl_smgr_truncate;

/* Maximum size of a null bitmap based on max number of attributes per tuple */
#define MaxNullBitmapLen	BITMAPLEN(MaxTupleAttributeNumber)

#endif /* PG_READAHEAD_H */
