/*-------------------------------------------------------------------------
 *
 * pageinfo.h
 *		Store information of data pages which should be read ahead.
 *
 * Portions Copyright (c) 2008, Nippon Telegraph and Telephone Corporation
 * Portions Copyright (c) 1996-2004, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *-------------------------------------------------------------------------
 */

#ifndef PAGEINFO_H
#define PAGEINFO_H

#include "postgres.h"
#include "storage/relfilenode.h"
#include "storage/block.h"
#include "access/xlogdefs.h"

/*
 * Prototype of public function.
 */
void pageinfo_init(void);
void pageinfo_add(RelFileNode node, BlockNumber blkno, uint32 xrecoff,
	bool has_fpw);
bool pageinfo_has_room(int num);
void pageinfo_read_ahead(void);

#endif /* PAGEINFO_H */

