#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <arpa/inet.h>

#include "test.h"

static void uint1_tables(PGconn *conn)
{
   PGresult *res;

   printf("[tables] uint1:\n");
   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   /*
    * Single uint1 column, NULLS permitted, with OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint1"
                      ") WITH OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint1 column, NULLS permitted, with OIDS: passed\n");


   /*
    * Single uint1 column, NULLS permitted, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint1"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint1 column, NULLS permitted, without OIDS: passed\n");


   /* 
    * Single uint1 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint1 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint1 column, NULLS prohibited, without OIDS: passed\n");



   /*
    * Multiple uint1 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint1 NOT NULL,"
                      "   col2 uint1 NOT NULL,"
                      "   col3 uint1 NOT NULL,"
                      "   col4 uint1 NOT NULL,"
                      "   col5 uint1 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint1 column, NULLS prohibited, without OIDS: passed\n");

    
   /*
    * Multiple uint1 column, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint1,"
                      "   col2 uint1 NOT NULL,"
                      "   col3 uint1,"
                      "   col4 uint1 NOT NULL,"
                      "   col5 uint1,"
                      "   col6 uint1 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint1 column, mixed NULLS, without OIDS: passed\n");


   /*
    * Mixed columns, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 \"char\" NOT NULL,"
                      "   col2 uint1,"
                      "   col3 int2,"
                      "   col4 uint1 NOT NULL,"
                      "   col5 text"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Mixed columns, mixed NULLS, without OIDS: passed\n");
}

static void uint2_tables(PGconn *conn)
{
   PGresult *res;

   printf("\n[tables] uint2:\n");
   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   /*
    * Single uint2 column, NULLS permitted, with OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint2"
                      ") WITH OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint2 column, NULLS permitted, with OIDS: passed\n");


   /*
    * Single uint2 column, NULLS permitted, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint2"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint2 column, NULLS permitted, without OIDS: passed\n");


   /* 
    * Single uint2 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint2 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint2 column, NULLS prohibited, without OIDS: passed\n");



   /*
    * Multiple uint2 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint2 NOT NULL,"
                      "   col2 uint2 NOT NULL,"
                      "   col3 uint2 NOT NULL,"
                      "   col4 uint2 NOT NULL,"
                      "   col5 uint2 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint2 column, NULLS prohibited, without OIDS: passed\n");

    
   /*
    * Multiple uint2 column, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint2,"
                      "   col2 uint2 NOT NULL,"
                      "   col3 uint2,"
                      "   col4 uint2 NOT NULL,"
                      "   col5 uint2,"
                      "   col6 uint2 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint2 column, mixed NULLS, without OIDS: passed\n");


   /*
    * Mixed columns, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 int2 NOT NULL,"
                      "   col2 uint2,"
                      "   col3 int4,"
                      "   col4 uint2 NOT NULL,"
                      "   col5 text"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Mixed columns, mixed NULLS, without OIDS: passed\n");
}


static void uint4_tables(PGconn *conn)
{
   PGresult *res;

   printf("\n[tables] uint4:\n");
   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   /*
    * Single uint4 column, NULLS permitted, with OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint4"
                      ") WITH OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint4 column, NULLS permitted, with OIDS: passed\n");


   /*
    * Single uint4 column, NULLS permitted, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint4"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint4 column, NULLS permitted, without OIDS: passed\n");


   /* 
    * Single uint4 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint4 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Single uint4 column, NULLS prohibited, without OIDS: passed\n");



   /*
    * Multiple uint4 column, NULLS prohibited, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint4 NOT NULL,"
                      "   col2 uint4 NOT NULL,"
                      "   col3 uint4 NOT NULL,"
                      "   col4 uint4 NOT NULL,"
                      "   col5 uint4 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint4 column, NULLS prohibited, without OIDS: passed\n");

    
   /*
    * Multiple uint4 column, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 uint4,"
                      "   col2 uint4 NOT NULL,"
                      "   col3 uint4,"
                      "   col4 uint4 NOT NULL,"
                      "   col5 uint4,"
                      "   col6 uint4 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Multiple uint4 column, mixed NULLS, without OIDS: passed\n");


   /*
    * Mixed columns, mixed NULLS, without OIDS.
    */
   res = PQexec(conn, "CREATE TABLE public.uint_table_test ("
                      "   col1 int4 NOT NULL,"
                      "   col2 uint4,"
                      "   col3 int2,"
                      "   col4 uint4 NOT NULL,"
                      "   col5 text"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "DROP TABLE public.uint_table_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
   printf("   Mixed columns, mixed NULLS, without OIDS: passed\n");
}


void test_tables(PGconn *conn)
{
   uint1_tables(conn);
   uint2_tables(conn);
   uint4_tables(conn);
}
