#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <arpa/inet.h>

#include "test.h"

void text_data(PGconn *conn)
{
   int i, status;
   PGresult *res;
   const char *paramValues[3];

   /*
    * Test PQexec.
    */
   res = PQexec(conn, "INSERT INTO public.uint_insert_test VALUES (4294967295, 65535, 255);");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "INSERT INTO public.uint_insert_test VALUES (4294967295::uint4, 65535::uint2, 255::uint1);");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   /* Verify the number of rows in the uint_insert_test table. */
   res = PQexec(conn, "SELECT * FROM public.uint_insert_test;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 2);
   assert(PQnfields(res) == 3);
   for(i = 0; i < PQntuples(res); ++i) {
      status = strcmp(PQgetvalue(res, i, 0), "4294967295");
      assert(status == 0);

      status = strcmp(PQgetvalue(res, i, 1), "65535");
      assert(status == 0);

      status = strcmp(PQgetvalue(res, i, 2), "255");
      assert(status == 0);
   }
   PQclear(res);

   printf("   PQexec test: passed\n");


   /*
    * Test PQexecParams
    */
   paramValues[0] = "4294967295";
   paramValues[1] = "65535";
   paramValues[2] = "255";

   res = PQexecParams(conn, "INSERT INTO public.uint_insert_test VALUES ($1::uint4, $2::uint2, $3::uint1);", 3, NULL, paramValues, NULL, NULL, 0);
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   /* Verify the number of rows in the uint_insert_test table. */
   res = PQexec(conn, "SELECT * FROM public.uint_insert_test;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 3);
   assert(PQnfields(res) == 3);
   for(i = 0; i < PQntuples(res); ++i) {
      status = strcmp(PQgetvalue(res, i, 0), "4294967295");
      assert(status == 0);

      status = strcmp(PQgetvalue(res, i, 1), "65535");
      assert(status == 0);

      status = strcmp(PQgetvalue(res, i, 2), "255");
      assert(status == 0);
   }
   PQclear(res);

   printf("   PQexecParams test: passed\n");
}

void binary_data(PGconn *conn)
{
   int i;
   unsigned int ui = htonl(4294967295), *ui2;
   unsigned short us = htons(65535), *us2;
   unsigned char uc = 255, *uc2;
   const char *paramValues[3];
   int paramLengths[3] = { 4, 2, 1 };
   int paramFormats[3] = { 1, 1, 1 };
   PGresult *res;

   /*
    * Test PQexecParams
    */
   paramValues[0] = (char *)&ui;
   paramValues[1] = (char *)&us;
   paramValues[2] = (char *)&uc;

   res = PQexecParams(conn, "INSERT INTO public.uint_insert_test VALUES ($1::uint4, $2::uint2, $3::uint1);", 3, NULL, paramValues, paramLengths, paramFormats, 0);
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   /* Verify the number of rows in the uint_insert_test table. */
   res = PQexecParams(conn, "SELECT * FROM public.uint_insert_test;", 0, NULL, NULL, NULL, NULL, 1);
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 4);
   assert(PQnfields(res) == 3);

   for(i = 0; i < PQntuples(res); ++i) {
      ui2 = (unsigned int *)PQgetvalue(res, i, 0);
      assert(ui == *ui2);

      us2 = (unsigned short *)PQgetvalue(res, i, 1);
      assert(us == *us2);

      uc2 = (unsigned char *)PQgetvalue(res, i, 2);
      assert(uc == *uc2);
   }
   PQclear(res);

   printf("   PQexecParams test: passed\n");
}

void test_insert(PGconn *conn)
{
   PGresult *res;

   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_insert_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "CREATE TABLE public.uint_insert_test ("
                      "   col1 uint4 NOT NULL,"
                      "   col2 uint2 NOT NULL,"
                      "   col3 uint1 NOT NULL"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
 
   printf("\n[insert] text:\n");
   text_data(conn);

   printf("\n[insert] binary:\n");
   binary_data(conn);

   res = PQexec(conn, "DROP TABLE public.uint_insert_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);
}
