#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <arpa/inet.h>

#include "test.h"

static void uint1_uint1_ops(PGconn *conn)
{
   int status;
   PGresult *res;

   printf("\n[comparision_ops] (uint1, uint1):\n");

   /*
    * Test the btuint1cmp function
    */
   res = PQexec(conn, "SELECT btuint1cmp(10::uint1, 11::uint1);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "-1");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint1cmp(10::uint1, 10::uint1);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint1cmp(11::uint1, 10::uint1);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "1");
   assert(status == 0);
   PQclear(res);

   printf("   btuint1cmp function: passed\n");


   /*
    * Test uint1eq
    */
   res = PQexec(conn, "SELECT 10::uint1 = 10::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 10::uint1 = 100::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1eq function (= operator): passed\n");


   /*
    * Test uint1ne
    */
   res = PQexec(conn, "SELECT 70::uint1 <> 80::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint1 <> 50::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1ne function (<> operator): passed\n");


   /*
    * Test uint1lt
    */
   res = PQexec(conn, "SELECT 70::uint1 < 80::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 < 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 < 60::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1lt function (< operator): passed\n");


   /*
    * Test uint1le
    */
   res = PQexec(conn, "SELECT 70::uint1 <= 80::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 <= 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 <= 60::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1le function (<= operator): passed\n");


   /*
    * Test uint1gt
    */
   res = PQexec(conn, "SELECT 80::uint1 > 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 > 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint1 > 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1gt function (> operator): passed\n");


   /*
    * Test uint1ge
    */
   res = PQexec(conn, "SELECT 80::uint1 >= 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint1 >= 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint1 >= 70::uint1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint1ge function (>= operator): passed\n");
}

static void uint2_uint2_ops(PGconn *conn)
{
   int status;
   PGresult *res;

   printf("\n[comparision_ops] (uint2, uint2):\n");

   /*
    * Test the btuint2cmp function
    */
   res = PQexec(conn, "SELECT btuint2cmp(10::uint2, 11::uint2);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "-1");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint2cmp(10::uint2, 10::uint2);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint2cmp(11::uint2, 10::uint2);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "1");
   assert(status == 0);
   PQclear(res);

   printf("   btuint2cmp function: passed\n");


   /*
    * Test uint2eq
    */
   res = PQexec(conn, "SELECT 10::uint2 = 10::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 10::uint2 = 100::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2eq function (= operator): passed\n");


   /*
    * Test uint2ne
    */
   res = PQexec(conn, "SELECT 70::uint2 <> 80::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint2 <> 50::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2ne function (<> operator): passed\n");


   /*
    * Test uint2lt
    */
   res = PQexec(conn, "SELECT 70::uint2 < 80::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 < 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 < 60::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2lt function (< operator): passed\n");


   /*
    * Test uint2le
    */
   res = PQexec(conn, "SELECT 70::uint2 <= 80::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 <= 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 <= 60::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2le function (<= operator): passed\n");


   /*
    * Test uint2gt
    */
   res = PQexec(conn, "SELECT 80::uint2 > 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 > 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint2 > 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2gt function (> operator): passed\n");


   /*
    * Test uint2ge
    */
   res = PQexec(conn, "SELECT 80::uint2 >= 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint2 >= 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint2 >= 70::uint2;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint2ge function (>= operator): passed\n");
}


static void uint4_uint4_ops(PGconn *conn)
{
   int status;
   PGresult *res;

   printf("\n[comparision_ops] (uint4, uint4):\n");

   /*
    * Test the btuint4cmp function
    */
   res = PQexec(conn, "SELECT btuint4cmp(10::uint4, 11::uint4);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "-1");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint4cmp(10::uint4, 10::uint4);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT btuint4cmp(11::uint4, 10::uint4);");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "1");
   assert(status == 0);
   PQclear(res);

   printf("   btuint4cmp function: passed\n");


   /*
    * Test uint4eq
    */
   res = PQexec(conn, "SELECT 10::uint4 = 10::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 10::uint4 = 100::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4eq function (= operator): passed\n");


   /*
    * Test uint4ne
    */
   res = PQexec(conn, "SELECT 70::uint4 <> 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint4 <> 50::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4ne function (<> operator): passed\n");


   /*
    * Test uint4lt
    */
   res = PQexec(conn, "SELECT 70::uint4 < 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 < 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 < 60::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4lt function (< operator): passed\n");


   /*
    * Test uint4le
    */
   res = PQexec(conn, "SELECT 70::uint4 <= 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 <= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 <= 60::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4le function (<= operator): passed\n");


   /*
    * Test uint4gt
    */
   res = PQexec(conn, "SELECT 80::uint4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4gt function (> operator): passed\n");


   /*
    * Test uint4ge
    */
   res = PQexec(conn, "SELECT 80::uint4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4ge function (>= operator): passed\n");
}


static void int4_uint4_ops(PGconn *conn)
{
   int status;
   PGresult *res;

   printf("\n[comparision_ops] (int4, uint4):\n");

   /*
    * Test int4uint4eq
    */
   res = PQexec(conn, "SELECT 10::int4 = 10::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 10::int4 = 100::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 = 100::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4eq function (= operator): passed\n");


   /*
    * Test int4uint4ne
    */
   res = PQexec(conn, "SELECT 70::int4 <> 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::int4 <> 50::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 <> 50::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4ne function (<> operator): passed\n");


   /*
    * Test int4uint4lt
    */
   res = PQexec(conn, "SELECT 70::int4 < 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 < 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 < 60::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 < 50::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4lt function (< operator): passed\n");


   /*
    * Test int4uint4le
    */
   res = PQexec(conn, "SELECT 70::int4 <= 80::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 <= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 <= 60::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 <= 60::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4le function (<= operator): passed\n");


   /*
    * Test int4uint4gt
    */
   res = PQexec(conn, "SELECT 80::int4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::int4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 > 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4gt function (> operator): passed\n");


   /*
    * Test int4uint4ge
    */
   res = PQexec(conn, "SELECT 80::int4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::int4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::int4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT -1::int4 >= 70::uint4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   int4uint4ge function (>= operator): passed\n");
}


static void uint4_int4_ops(PGconn *conn)
{
   int status;
   PGresult *res;

   printf("\n[comparision_ops] (uint4, int4):\n");

   /*
    * Test uint4int4eq
    */
   res = PQexec(conn, "SELECT 10::uint4 = 10::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 10::uint4 = 100::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 100::uint4 = -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4eq function (= operator): passed\n");


   /*
    * Test uint4int4ne
    */
   res = PQexec(conn, "SELECT 70::uint4 <> 80::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint4 <> 50::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint4 <> -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4ne function (<> operator): passed\n");


   /*
    * Test uint4int4lt
    */
   res = PQexec(conn, "SELECT 70::uint4 < 80::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 < 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 < 60::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 50::uint4 < -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4lt function (< operator): passed\n");


   /*
    * Test uint4int4le
    */
   res = PQexec(conn, "SELECT 70::uint4 <= 80::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 <= 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 <= 60::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint4 <= -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4le function (<= operator): passed\n");


   /*
    * Test uint4int4gt
    */
   res = PQexec(conn, "SELECT 80::uint4 > 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 > 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint4 > 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 > -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4gt function (> operator): passed\n");


   /*
    * Test uint4int4ge
    */
   res = PQexec(conn, "SELECT 80::uint4 >= 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 >= 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 60::uint4 >= 70::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "f");
   assert(status == 0);
   PQclear(res);

   res = PQexec(conn, "SELECT 70::uint4 >= -1::int4;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQntuples(res) == 1);
   assert(PQnfields(res) == 1);
   status = strcmp(PQgetvalue(res, 0, 0), "t");
   assert(status == 0);
   PQclear(res);

   printf("   uint4int4ge function (>= operator): passed\n");
}

void test_comparison_ops(PGconn *conn)
{
   uint1_uint1_ops(conn);
   uint2_uint2_ops(conn);
   uint4_uint4_ops(conn);
   int4_uint4_ops(conn);
   uint4_int4_ops(conn);
}
