#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "test.h"

int main()
{
   PGconn *conn; 
   PGresult *res;

   /*
    * Establish database connection
    */
   conn = PQconnectdb("host=127.0.0.1 dbname=uint user=rbrad");
   assert(PQstatus(conn) == CONNECTION_OK);

   /*
    * Ignore NOTICE messages (i.e. from DROP TABLE IF EXISTS....)
    */
   res = PQexec(conn, "SET client_min_messages = WARNING;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   test_tables(conn);
   test_comparison_ops(conn);
   test_insert(conn);
   test_copy(conn);
   test_indexes(conn);

   PQfinish(conn);
   return 0;
}
