#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <arpa/inet.h>

#include "test.h"


static void uint1_btree_primary_key(PGconn *conn)
{
   int status;
   PGresult *res;

   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   res = PQexec(conn, "CREATE TABLE public.uint_index_test ("
                      "   col1 uint1 PRIMARY KEY"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES "
                      "(1), (2), (3), (4), (10), (9), (8), (7), "
                      "(128), (0), (5), (133), (192), (64), (255), (127);");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "SELECT col1 FROM public.uint_index_test ORDER BY col1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQnfields(res) == 1);
   assert(PQntuples(res) == 16);

   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 1, 0), "1");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 2, 0), "2");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 3, 0), "3");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 4, 0), "4");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 5, 0), "5");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 6, 0), "7");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 7, 0), "8");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 8, 0), "9");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 9, 0), "10");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 10, 0), "64");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 11, 0), "127");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 12, 0), "128");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 13, 0), "133");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 14, 0), "192");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 15, 0), "255");
   assert(status == 0);

   PQclear(res);

   /*
    * Test collision.
    */
   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES (64);");
   assert(PQresultStatus(res) == PGRES_FATAL_ERROR);

   /*
    * Drop the test table.
    */
   res = PQexec(conn, "DROP TABLE public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   printf("   uint1: passed\n");
}

static void uint2_btree_primary_key(PGconn *conn)
{
   int status;
   PGresult *res;

   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   res = PQexec(conn, "CREATE TABLE public.uint_index_test ("
                      "   col1 uint2 PRIMARY KEY"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES "
                      "(1), (2), (3), (4), (65535), (65534), (65533), (65532), "
                      "(32768), (0), (32767), (127), (255), (128), (256), (40000);");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "SELECT col1 FROM public.uint_index_test ORDER BY col1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQnfields(res) == 1);
   assert(PQntuples(res) == 16);

   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 1, 0), "1");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 2, 0), "2");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 3, 0), "3");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 4, 0), "4");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 5, 0), "127");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 6, 0), "128");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 7, 0), "255");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 8, 0), "256");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 9, 0), "32767");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 10, 0), "32768");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 11, 0), "40000");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 12, 0), "65532");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 13, 0), "65533");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 14, 0), "65534");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 15, 0), "65535");
   assert(status == 0);

   PQclear(res);

   /*
    * Test collision.
    */
   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES (40000);");
   assert(PQresultStatus(res) == PGRES_FATAL_ERROR);

   /*
    * Drop the test table.
    */
   res = PQexec(conn, "DROP TABLE public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   printf("   uint2: passed\n");
}


static void uint4_btree_primary_key(PGconn *conn)
{
   int status;
   PGresult *res;

   /*
    * Ensure the test table does not exist.
    */
   res = PQexec(conn, "DROP TABLE IF EXISTS public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);


   res = PQexec(conn, "CREATE TABLE public.uint_index_test ("
                      "   col1 uint4 PRIMARY KEY"
                      ") WITHOUT OIDS;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES "
                      "(1), (2), (3), (4), (4294967295), (4294967294), (4294967293), (4294967292), "
                      "(2147483647), (0), (255), (2147483648), (254), (127), (256), (4000000000);");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   res = PQexec(conn, "SELECT col1 FROM public.uint_index_test ORDER BY col1;");
   assert(PQresultStatus(res) == PGRES_TUPLES_OK);
   assert(PQnfields(res) == 1);
   assert(PQntuples(res) == 16);

   status = strcmp(PQgetvalue(res, 0, 0), "0");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 1, 0), "1");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 2, 0), "2");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 3, 0), "3");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 4, 0), "4");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 5, 0), "127");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 6, 0), "254");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 7, 0), "255");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 8, 0), "256");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 9, 0), "2147483647");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 10, 0), "2147483648");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 11, 0), "4000000000");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 12, 0), "4294967292");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 13, 0), "4294967293");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 14, 0), "4294967294");
   assert(status == 0);

   status = strcmp(PQgetvalue(res, 15, 0), "4294967295");
   assert(status == 0);

   PQclear(res);

   /*
    * Test collision.
    */
   res = PQexec(conn, "INSERT INTO public.uint_index_test VALUES (4000000000);");
   assert(PQresultStatus(res) == PGRES_FATAL_ERROR);

   /*
    * Drop the test table.
    */
   res = PQexec(conn, "DROP TABLE public.uint_index_test;");
   assert(PQresultStatus(res) == PGRES_COMMAND_OK);
   PQclear(res);

   printf("   uint4: passed\n");
}


void test_indexes(PGconn *conn)
{
   printf("\n[indexes] primary key (btree):\n");
   uint1_btree_primary_key(conn);
   uint2_btree_primary_key(conn);
   uint4_btree_primary_key(conn);
}
