#!/usr/sbin/dtrace -s
/*
 * Usage: ./sort_time.d <pid>
 * This script prints out the stats for heap, index and datum sort.
 */

#pragma D option quiet

dtrace:::BEGIN
{
        type[0] = "HEAP SORT";
        type[1] = "INDEX SORT";
        type[2] = "DATUM SORT";
}

postgresql$1:::sort-start
/arg0 == 0/
{
	self->ts = timestamp;
	printf ("%s: nkeys = %d, workMem = %d, randomAccess = %s", type[arg0], arg2, arg3, arg4 ? "true" : "false");
}

postgresql$1:::sort-start
/arg0 == 1/
{
	self->ts = timestamp;
	printf ("%s: unique = %s, workMem = %d, randomAccess = %s ", type[arg0], arg1 ? "true" : "false", arg3, arg4 ? "true" : "false");
}

postgresql$1:::sort-start
/arg0 == 2/
{
	self->ts = timestamp;
	printf ("%s: workMem = %d, randomAccess = %s ", type[arg0], arg3, arg4 ? "true" : "false");
}

postgresql$1:::sort-end
/self->ts/
{
	printf (", time = %d (ns)\n", timestamp - self->ts);
        self->ts = 0;
}
