#!/usr/sbin/dtrace -s
/*
 * Usage  : ./checkpoint_stats.d
 *
 * This script reports checkpoint statistics. The default checkpoint_timeout is 5mins, so 
 * reduce it to, say 30s, so you won't have to wait long to see the results.
 */

#pragma D option quiet

postgresql*:::checkpoint-start
{
	printf("%Y : Checkpoint started\n", walltimestamp);
	self->ts = timestamp;
}

postgresql*:::checkpoint-done
/self->ts && arg0 == 4294967295/
{
	printf("%Y : Checkpoint skipped (idle system) \n\n", walltimestamp);
        self->ts = 0;
}

postgresql*:::checkpoint-done
/self->ts && arg1 != 4294967295/
{
	this->elapsed = timestamp - self->ts;

	printf ("%Y : Checkpoint complete \n", walltimestamp); 
	printf ("Wrote %d of %d buffers (%.1d%%) \n", arg0, arg1, arg0 * 100 / arg1);
	printf ("%d xlog file(s) added, %d removed, %d recycled \n", arg2, arg3, arg4);
	printf ("Checkpoint time =  %3d.%03d sec (%d ns) \n\n", this->elapsed / 1000000000, (this->elapsed / 1000000) % 1000, this->elapsed);

	self->ts = 0;
}
