#!/usr/sbin/dtrace -s
/*
 * Usage: ./wal_buffer_write.d <pid>
 * This script prints the I/O performed when not enough space is allocated
 * for the per transaction WAL buffer space because wal_buffers is too small.
 * If wal_buffers is set to a correct size, you will not see any output.
 */

#pragma D option quiet

postgresql$1:::wal-buffer-write-start
{
	self->ts = timestamp;
}

postgresql$1:::wal-buffer-write-done
/self->ts/
{
	@count["WAL buffer writes so far"] = count();
	@countpersec["WAL buffer writes per second"] = count();
	@avgtime["Average write time (ns)"] = avg (timestamp - self->ts);
        self->ts = 0;
}

profile:::tick-1s
{
        printa("%20s %@14d\n",@count);
        printa("%25s %@10d\n",@countpersec);
        printa("%20s %@15d\n\n",@avgtime);

	clear(@countpersec);
}

