#!/usr/sbin/dtrace -s
/*
 * Usage: ./idle_time.d <pid>
 * This script prints the idle in transaction time or client/network time.
 */

#pragma D option quiet

postgresql$1:::idle-transaction-start
{
	self->ts = timestamp;
}

postgresql$1:::idle-transaction-done
/self->ts/
{
	printf ("Idle in transaction for %10d (ns)\n", timestamp - self->ts);
        self->ts = 0;
}

