#!/usr/sbin/dtrace -s
/*
 * Usage: ./deadlock_check.d <pid>
 * This script prints the deadlocks found and not found by the deadlock 
 * detector.
 */

#pragma D option quiet

postgresql$1:::deadlock-found
{
	@fcount["Number of found deadlocks"] = count();
}

postgresql$1:::deadlock-notfound
{
	@nfcount["Number of notfound deadlocks", arg0] = count();
}

profile:::tick-1s
{
        printa("%25s %@5d\n",@fcount);
        printa("%25s %5d %@5d\n",@nfcount);
}
