#!/usr/sbin/dtrace -s
/*
 * Usage: ./stmt_time_breakdown.d <pid>
 * This script breaks down the time into parsing, planning, and execution
 * for each statement.
 */

#pragma D option quiet

postgresql$1:::query-parse-start
{
	printf("Statement: %s\n", copyinstr(arg0));
	self->ts = timestamp;
}

postgresql$1:::query-parse-done
/self->ts/
{
        printf("Query PARSING   time: %d\n", (timestamp - self->ts));
        self->follow = 1;
}

postgresql$1:::query-plan-start
/self->follow/
{
	self->ts = timestamp;
}

postgresql$1:::query-plan-done
/self->follow/
{
        printf("Query PLANNING  time: %d\n", (timestamp - self->ts));
}

postgresql$1:::query-execute-start
/self->follow/
{
	self->ts = timestamp;
}

postgresql$1:::query-execute-done
/self->follow/
{
        printf("Query EXECUTION time: %d\n\n", (timestamp - self->ts));
        self->follow = 0;
}
