#!/usr/sbin/dtrace -s
/*
 * Usage  : ./smgr_io.d
 *
 * This script reports the storage manager's read/write statistics.
 */

#pragma D option quiet

postgresql*:::smgr-read-start
{
	self->ts = timestamp;
}

postgresql*:::smgr-read-done
/self->ts/
{
	@readcount[arg1, arg2, arg3] = count();
/*
	@blocknum[arg0] = count();
	@avgtime["Avg read time"] = avg (timestamp - self->ts);
*/
        self->ts = 0;
}

postgresql*:::smgr-write-start
{
	self->ts = timestamp;
}

postgresql*:::smgr-write-done
/self->ts/
{
	@writecount[arg1, arg2, arg3] = count();
/*
	@blocknum[arg0] = count();
	@avgtime["Avg read time"] = avg (timestamp - self->ts);
*/
        self->ts = 0;
}

profile:::tick-1s
{
	trunc(@readcount, 5);
	printf("\n=============== Read stats ================\n");
	printf("%10s %10s %10s %10s\n","Tablespace", "Database", "Table", "Count");
        printa("%10d %10d %10d %@10d\n",@readcount);

	trunc(@writecount, 5);
	printf("\n=============== Write stats ===============\n");
	printf("%10s %10s %10s %10s\n","Tablespace", "Database", "Table", "Count");
        printa("%10d %10d %10d %@10d\n",@writecount);

/*
	trunc(@blocknum, 5);
	printf("\nTop 5 frequently accessed block numbers\n");
	printf("%10s %10s\n","Block Number", "Count");
        printa("%10d %@10d\n",@blocknum);
        printa("\n%10s %@10d (ns)\n\n",@avgtime);
*/
}
	

