#!/usr/sbin/dtrace -s
/*
 * Usage: ./dirty_buffer_write.d <pid>
 * Example: (1) run pgbench (2) ./dirty_buffer_write.d `pgrep -n postgres` 
 *
 * This script prints the number of writes performed by the server process
 * because the bgwriter is ineffective or shared_buffers is too small.
 * If shared_buffers is set to the appropriate value and the bgwriter works
 * properly, you won't see the backend doing many dirty buffer writes.
 */

#pragma D option quiet

postgresql$1:::dirty-buffer-write-start
{
	self->ts = timestamp;
}
postgresql$1:::dirty-buffer-write-done
/self->ts/
{
	@count["Dirty buffer written so far"] = count();
	@countpersec["Dirty buffer writes per second"] = count();
	@avgtime["Average write time (ns)"] = avg (timestamp - self->ts);
        self->ts = 0;
}

profile:::tick-1s
{
        printa("%20s %@12d\n",@count);
        printa("%25s %@8d\n",@countpersec);
        printa("%20s %@15d\n\n",@avgtime);

	clear(@countpersec);
}
