#!/bin/sh

DATADIR=/mnt/data/hot-data

# create output directory
LOGDIR=`mktemp -d log-XXXX`

# Collect some basic information on the test run.

date > $LOGDIR/info.txt
echo $PATH >> $LOGDIR/info.txt

# Clean up any previous test run.
pg_ctl stop -D ${DATADIR} -w
rm -rf ${DATADIR}


# Initialize new cluster
initdb ${DATADIR}
cp postgresql.conf ${DATADIR}
pg_ctl start -D ${DATADIR} -w -l $LOGDIR/server-log

psql postgres <<EOF

CREATE LANGUAGE plpgsql;

create or replace function from_hex( param text ) returns bigint as \$\$
declare
x bigint := 0;
i integer := 0;
len integer;
c char;
str varchar;
begin
  str := lower(param);
  len := length( str );
  loop
    i := i + 1;
    exit when i > len;
    c := substring( str, i, 1 );
    if ( ( c >= '0' ) and ( c <= '9' ) )  then
      x := x * 16 + ascii(c) - 48;
    elsif ( ( c >= 'a' ) and ( c <= 'f' ) )  then
      x := x * 16 + ascii(c) - 87;
    else
      RAISE EXCEPTION 'Invalid Hexadecimal Number String';
    end if;
  end loop;
  return x;
end;
\$\$ language plpgsql strict immutable;

-- Note: the correctness of these calculations depend on XLOG_SEG_SIZE.
create or replace function xlogpos_to_bigint(xlogpos text) returns bigint as \$\$
  SELECT xlogid*from_hex('ff000000')+xrecoff FROM (
     SELECT from_hex(split_part(\$1, '/', 1)) AS xlogid,
            from_hex(split_part(\$1, '/', 2)) AS xrecoff) AS foo
\$\$ language sql strict immutable;

CREATE TABLE wal_before (xlogpos text);

EOF

echo "initializing pgbench"

pgbench -i -s 10 postgres > $LOGDIR/pgbench.out

psql postgres -c "CHECKPOINT"

# Take a snapshot of the WAL insert location before tests
psql postgres -c "INSERT INTO wal_before VALUES (pg_current_xlog_insert_location());"

vmstat 10 > $LOGDIR/vmstat.out &

echo "running"
pgbench -c 5 -t 1000000 postgres -l >> $LOGDIR/pgbench.out
echo "done"
mv pgbench_log* $LOGDIR
killall vmstat

psql postgres -c "SELECT xlogpos_to_bigint(pg_current_xlog_insert_location()) - xlogpos_to_bigint(xlogpos) AS wal_written FROM wal_before" >> $LOGDIR/info.txt

pg_ctl stop -D ${DATADIR} -w
