#include "postgres.h"

#include <time.h>
#include <sys/time.h>

#include "pg_crc.h"

int
main()
{
	char		buffer[TESTSIZE];
	pg_crc32	mycrc;
	int			j;
	struct timeval tstart;
	struct timeval tstop;

    srand(100/*time(NULL)*/);
    for (j = 0; j < TESTSIZE; ++j)
		buffer[j] = (char) (255 * (rand() / (RAND_MAX + 1.0)));

	gettimeofday(&tstart, NULL);

	for (j = 0; j < NTESTS; j++)
	{
		INIT_CRC32(mycrc);
		COMP_CRC32(mycrc, buffer, TESTSIZE);
		FIN_CRC32(mycrc);
	}

	gettimeofday(&tstop, NULL);

	if (tstop.tv_usec < tstart.tv_usec)
	{
		tstop.tv_sec--;
		tstop.tv_usec += 1000000;
	}

	printf("crc = %X, bufsize = %d, loops = %d, elapsed = %ld.%06ld\n",
		   mycrc, TESTSIZE, NTESTS,
		   (long) (tstop.tv_sec - tstart.tv_sec),
		   (long) (tstop.tv_usec - tstart.tv_usec));

	return 0;
}
