/*-------------------------------------------------------------------------
 *
 * execPara.c
 *	  Parallel execution support routines
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#ifdef PAR_SERVER

#include "nodes/parsenodes.h"
#include "nodes/execnodes.h"
#include "access/printtup.h"
#include "storage/conqueue.h"

/* defined in readfuncs.c */
extern bool for_parallel_server;

/*
 * ExecParaGetQuery
 * 		Get parse tree from the parallel initiator
 */
Query *
ExecParaGetQuery(void)
{
	char	*query;
	Query	*queryTree;

	query = CQueueGetQuery(0);
	for_parallel_server = true;
	queryTree = stringToNode(query);
	for_parallel_server = false;

	return queryTree;
}

/*
 * ExecParaGetPlan
 * 		Get plan tree from the parallel initiator
 */
Plan *
ExecParaGetPlan(void)
{
	char	*plan;
	Plan	*planTree;
	
	plan = CQueueGetPlan(0);
	for_parallel_server = true;
	planTree = stringToNode(plan);
	for_parallel_server = false;

	return planTree;
}

/*
 * Format:
 * [tuplen][tuple data ...]
 */
uint16
ExecParaWriteTuple(TupleTableSlot *slot, char *buffer)
{
	char		*pbuffer = buffer;
	HeapTuple	tuple = (HeapTuple) slot->tts_tuple;
	unsigned int tuplen;
	
	tuplen = tuple->t_len + sizeof(tuplen);
	memcpy(pbuffer, (void *) &tuplen, sizeof(tuplen));
	pbuffer += sizeof(tuplen);
	
	memcpy(pbuffer, (void *) tuple->t_data, tuple->t_len);

	return tuplen;
}

HeapTuple
ExecParaReadTuple(char *buffer, uint16 len)
{
	char		*pbuffer = buffer;
	unsigned int tuplen = len - sizeof(unsigned int) + HEAPTUPLESIZE;
	HeapTuple	tuple = (HeapTuple) palloc(tuplen);

	/* The input must be a valid data */
	Assert(((CQueueMember *)buffer)->type == CQ_DATA);

	pbuffer += sizeof(tuplen);
	tuple->t_len = len - sizeof(unsigned int);
	ItemPointerSetInvalid(&(tuple->t_self));
	tuple->t_tableOid = InvalidOid;
	tuple->t_data = (HeapTupleHeader) (((char *) tuple) + HEAPTUPLESIZE);
	/* read in the tuple proper */
	memcpy((void *) tuple->t_data, pbuffer, tuple->t_len);

	return tuple;
}

/*
 * Follow the logic in writetup_heap()
 */
void
ExecParaDestReceive(TupleTableSlot *slot, DestReceiver *self)
{
	char		buffer[BLCKSZ];
	uint16		tuplen;

	tuplen = ExecParaWriteTuple(slot, buffer);
	CQueuePut(0, (void *)buffer, tuplen);
}

void
ExecParaDestStartup(DestReceiver *self, int operation, TupleDesc typeinfo)
{
	/* nothing to do */
}

void
ExecParaDestShutdown(DestReceiver *self)
{
	CQueueDone(0);
}

void
ExecParaDestDestroy(DestReceiver *self)
{
	/* nothing to do */
}



#endif /* PAR_SERVER */

