
#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <stdio.h>
#include <setjmp.h>

#include "postgres.h"
#include "fmgr.h"
#include "executor/spi.h"

static char *lc_collate_cache = NULL;
static int multiplication = 1;
PG_FUNCTION_INFO_V1(nls_string);

Datum
nls_string(PG_FUNCTION_ARGS) 
{
	text *locale = PG_GETARG_TEXT_P(1);
	char *locale_str;
	int locale_len;
	
	text *txt = PG_GETARG_TEXT_P(0);
	char *txt_str;
	int txt_len;
	text *txt_out;
	char *txt_tmp;
	size_t size = 0;
	size_t rest = 0;
	int i;
	int changed_locale = 0;
	sigjmp_buf save_restart;

	if ((VARSIZE(locale) - VARHDRSZ) <= 0 || (VARSIZE(txt) - VARHDRSZ) < 0)
		PG_RETURN_TEXT_P(txt);
	
	/*
	 * Save original locale setting
	 */
	if (!lc_collate_cache)
	{
		if ((lc_collate_cache = setlocale(LC_COLLATE, NULL)))
			/* cached independent on PostgreSQL mmgr */
			lc_collate_cache = strdup(lc_collate_cache);
	}
	if (!lc_collate_cache)
		elog(ERROR, "invalid system LC_COLLATE setting");

	/*
	 * Conversion to standard strings
	 */
	txt_len = VARSIZE(txt) - VARHDRSZ;
	txt_str = palloc(txt_len + 1);
	memcpy(txt_str, VARDATA(txt), txt_len);
	*(txt_str + txt_len) = '\0';

	locale_len = VARSIZE(locale) - VARHDRSZ;
	if (strncmp(lc_collate_cache, VARDATA(locale), locale_len)
		|| *(lc_collate_cache + locale_len) != '\0')
		changed_locale = 1;
	/*
	 * If nonstandard locale is requested
	 */
	if (changed_locale)
	{
		locale_str = palloc(locale_len + 1);
		memcpy(locale_str, VARDATA(locale), locale_len);
		*(locale_str + locale_len) = '\0';

		/*
		 * Catch elog() and set correct locales
		 */
		memcpy(&save_restart, &Warn_restart, sizeof(save_restart));
		if (sigsetjmp(Warn_restart, 1) != 0)
		{
			memcpy(&Warn_restart, &save_restart, sizeof(Warn_restart));
			setlocale(LC_COLLATE, lc_collate_cache);
			siglongjmp(Warn_restart, 1);
		}
		
		/*
		 * Set wanted locale
		 */
		if (!setlocale(LC_COLLATE, locale_str))
			elog(ERROR, "invalid LC_COLLATE setting: %s", locale_str);
		
		pfree(locale_str);
	}

	/*
	 * Text transformation
	 */
	size = txt_len * multiplication + 1;
	txt_tmp = palloc(size);

	rest = strxfrm(txt_tmp, txt_str, size);
	while (rest >= size) 
	{
		pfree(txt_tmp);
		size = rest + 1;
		txt_tmp = palloc(size);
		rest = strxfrm(txt_tmp, txt_str, size);
		if (txt_len)
			multiplication = (rest / txt_len) + 2;
	}

	if (txt_len && rest < txt_len * multiplication / 4)
		multiplication = (rest / txt_len) + 1;
	
	/*
	 * Transformation to unsigned octal
	 */
	txt_out = (text *) palloc(3 * rest + VARHDRSZ + 1);
	
	for (i = 0; i < rest; i++) 
	{
		sprintf(VARDATA(txt_out) + 3 * i, "%03o",
			(int)(unsigned char)*(txt_tmp + i));
	}
	pfree(txt_tmp);
	pfree(txt_str);

	VARATT_SIZEP(txt_out) = 3 * rest + VARHDRSZ;

	if (changed_locale)
	{
		/*
		 * Set original locale
		 */
		if (!setlocale(LC_COLLATE, lc_collate_cache))
			elog(ERROR, "invalid LC_COLLATE setting: %s", lc_collate_cache);
		
		/*
		 * Restore normal error handing
		 */
		memcpy(&Warn_restart, &save_restart, sizeof(Warn_restart));
	}

	PG_RETURN_TEXT_P(txt_out);
}

