/*
 * server side function for talking to remote sockets
 */


/* including PostgreSQL specific stuff */
#include "postgres.h"
#include "fmgr.h"
#include "funcapi.h"
#include "utils/builtins.h"

/* include network library */
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

/* include TecWing stuff */
#include "tecwing.h"

/* macros taken from dblink */
#define GET_TEXT(cstrp) DatumGetTextP(DirectFunctionCall1(textin, CStringGetDatum(cstrp)))
#define GET_STR(textp) DatumGetCString(DirectFunctionCall1(textout, PointerGetDatum(textp)))
#define xpfree(var_) \
	do { \
		if (var_ != NULL) \
		{ \
			pfree(var_); \
			var_ = NULL; \
		} \
	} while (0)

/* implementing function */
PG_FUNCTION_INFO_V1(tecwing_socket);
Datum
tecwing_socket(PG_FUNCTION_ARGS)
{
	int	port = 0;
	port = PG_GETARG_INT32(1);
	
	/* if you want to see what's going on in your system turn the following
	 * lines on */
	/* elog(NOTICE, "host: %s", GET_STR(PG_GETARG_TEXT_P(0)));
	elog(NOTICE, "port: %d", port);
	elog(NOTICE, "data: %s", GET_STR(PG_GETARG_TEXT_P(2))); */

	/* defining network related stuff */
	struct 	sockaddr_in servAddr, localAddr;
	struct 	hostent *h;
	int	sd, rc;

	h = gethostbyname(GET_STR(PG_GETARG_TEXT_P(0)));
	if	(h == NULL) 
	{
		PG_RETURN_TEXT_P(GET_TEXT("ERROR HOST"));
	}

      	servAddr.sin_family = h->h_addrtype;
        memcpy((char *) &servAddr.sin_addr.s_addr, h->h_addr_list[0], h->h_length);
	servAddr.sin_port = htons(port);

	/* create socket */
	sd = socket(AF_INET, SOCK_STREAM, 0);
	if	(sd < 0) 
	{
		PG_RETURN_TEXT_P(GET_TEXT("ERROR DESCRIPTOR"));
        }

        /* bind any port number */
        localAddr.sin_family = AF_INET;
	localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	localAddr.sin_port = htons(0);
	      
	rc = bind(sd, (struct sockaddr *) &localAddr, sizeof(localAddr));
	if	(rc < 0) 
	{
		PG_RETURN_TEXT_P(GET_TEXT("ERROR BINDING PORT"));
	}
							
	/* connect to server */
	rc = connect(sd, (struct sockaddr *) &servAddr, sizeof(servAddr));
	if	(rc < 0) 
	{
		PG_RETURN_TEXT_P(GET_TEXT("ERROR RC"));
	}

	rc = send(sd, GET_STR(PG_GETARG_TEXT_P(2)), 
		strlen(GET_STR(PG_GETARG_TEXT_P(2))) + 1, 0);
	if	(rc < 0) 
	{
		PG_RETURN_TEXT_P(GET_TEXT("CANNOT SEND"));
	}

	close(sd);

	PG_RETURN_TEXT_P(GET_TEXT("OK"));
}

