--
-- PostgreSQL database dump
--

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;

SET SESSION AUTHORIZATION 'postgres';

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO PUBLIC;


SET SESSION AUTHORIZATION 'jwscott';

SET search_path = public, pg_catalog;

--
-- Name: contract_plan_constraint(integer); Type: FUNCTION; Schema: public; Owner: jwscott
--

CREATE FUNCTION contract_plan_constraint(integer) RETURNS boolean
    AS '
    SELECT EXISTS (SELECT contract_id FROM plan WHERE contract_id = $1);
'
    LANGUAGE sql;


--
-- Name: contract; Type: TABLE; Schema: public; Owner: jwscott
--

CREATE TABLE contract (
    contract_id integer NOT NULL,
    CONSTRAINT contract_plan CHECK (contract_plan_constraint(contract_id))
) WITHOUT OIDS;


--
-- Name: plan; Type: TABLE; Schema: public; Owner: jwscott
--

CREATE TABLE plan (
    plan_id integer NOT NULL,
    contract_id integer NOT NULL
) WITHOUT OIDS;


--
-- Data for Name: contract; Type: TABLE DATA; Schema: public; Owner: jwscott
--

COPY contract (contract_id) FROM stdin;
1
\.


--
-- Data for Name: plan; Type: TABLE DATA; Schema: public; Owner: jwscott
--

COPY plan (plan_id, contract_id) FROM stdin;
1	1
\.


--
-- Name: contract_pkey; Type: CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY contract
    ADD CONSTRAINT contract_pkey PRIMARY KEY (contract_id);


--
-- Name: plan_pkey; Type: CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY plan
    ADD CONSTRAINT plan_pkey PRIMARY KEY (plan_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY plan
    ADD CONSTRAINT "$1" FOREIGN KEY (contract_id) REFERENCES contract(contract_id) DEFERRABLE INITIALLY DEFERRED;


