--
-- PostgreSQL database dump
--

SET SESSION AUTHORIZATION 'postgres';

--
-- TOC entry 3 (OID 2200)
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO PUBLIC;


SET SESSION AUTHORIZATION 'jwscott';

SET search_path = public, pg_catalog;

--
-- TOC entry 4 (OID 17212)
-- Name: contract; Type: TABLE; Schema: public; Owner: jwscott
--

CREATE TABLE contract (
    contract_id integer NOT NULL,
    CONSTRAINT contract_plan CHECK (contract_plan_constraint(contract_id))
) WITHOUT OIDS;


--
-- TOC entry 5 (OID 17216)
-- Name: plan; Type: TABLE; Schema: public; Owner: jwscott
--

CREATE TABLE plan (
    plan_id integer NOT NULL,
    contract_id integer NOT NULL
) WITHOUT OIDS;


SET check_function_bodies = false;

--
-- TOC entry 8 (OID 17224)
-- Name: contract_plan_constraint(integer); Type: FUNCTION; Schema: public; Owner: jwscott
--

CREATE FUNCTION contract_plan_constraint(integer) RETURNS boolean
    AS '
    SELECT EXISTS (SELECT contract_id FROM plan WHERE contract_id = $1);
'
    LANGUAGE sql;


--
-- Data for TOC entry 9 (OID 17212)
-- Name: contract; Type: TABLE DATA; Schema: public; Owner: jwscott
--

COPY contract (contract_id) FROM stdin;
1
\.


--
-- Data for TOC entry 10 (OID 17216)
-- Name: plan; Type: TABLE DATA; Schema: public; Owner: jwscott
--

COPY plan (plan_id, contract_id) FROM stdin;
1	1
\.


--
-- TOC entry 6 (OID 17214)
-- Name: contract_pkey; Type: CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY contract
    ADD CONSTRAINT contract_pkey PRIMARY KEY (contract_id);


--
-- TOC entry 7 (OID 17218)
-- Name: plan_pkey; Type: CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY plan
    ADD CONSTRAINT plan_pkey PRIMARY KEY (plan_id);


--
-- TOC entry 11 (OID 17220)
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: jwscott
--

ALTER TABLE ONLY plan
    ADD CONSTRAINT "$1" FOREIGN KEY (contract_id) REFERENCES contract(contract_id) DEFERRABLE INITIALLY DEFERRED;


SET SESSION AUTHORIZATION 'postgres';

--
-- TOC entry 2 (OID 2200)
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


