#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>

#define ETH_NUMBER 0
#define MAX_ADJUSTMENT 10

#define TIME_OFFSET_HIGH 0x01B21DD2
#define TIME_OFFSET_LOW 0x13814000

typedef unsigned int uint32;
typedef unsigned short int uint16;
typedef unsigned char uint8;
typedef unsigned long long int uint64;

typedef struct uuid
{
	uint32 time_low;
	uint16 time_mid;
	uint16 time_hi_and_version;
	uint8 clock_seq_hi_and_reserved;
	uint8 clock_seq_low;
	uint8 node[6];
} uuid;

static int pseudo_random_buffer(void *buffer, size_t nbytes);
static int true_random_buffer(void *buffer, size_t nbytes);
static void random_buffer(void *buffer, size_t nbytes);
static int get_system_timestamp(uint64 *ret_timestamp);
static int get_current_clock_seq(uint16 *ret_clock_seq);
static int get_system_time_and_clock(
		uint32 *clock_high,
		uint32 *clock_low,
		uint16 *ret_clock_seq);
int generate_time(struct uuid *ret_uptr);
int uuid2str(const struct uuid *uptr, unsigned char *str);

int main(int argc, char* argv[])
{
	struct uuid u;
	unsigned char out[40];

	generate_time(&u);

	uuid2str(&u, out);
	printf("%s\n");

	return (0);
}

int uuid2str(const struct uuid *uptr, unsigned char *str)
{
	sprintf(str,
		"%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x",
		uptr->time_low, uptr->time_mid, uptr->time_hi_and_version,
		uptr->clock_seq_hi_and_reserved, uptr->clock_seq_low,
		uptr->node[0], uptr->node[1], uptr->node[2],
		uptr->node[3], uptr->node[4], uptr->node[5]);

	return (0);
}

static int pseudo_random_buffer(void *buffer, size_t nbytes)
{
	struct timeval tv;
	int i;

	unsigned char *bp = (unsigned char *)buffer;


	gettimeofday(&tv, 0);
	srand(tv.tv_sec);
	for (i = (tv.tv_sec ^ tv.tv_usec) & 0x1F; i > 0; i--)
	{
		rand();
	}

	for (i = 0; i < nbytes; i++)
	{
		bp[i] ^= (rand() >> 7) & 0xFF;
	}
	return (0);
}

static int true_random_buffer(void *buffer, size_t nbytes)
{
	struct timeval tv;
	int fd;
	int i;
	int n = nbytes;
	int lose_counter = 0;
	unsigned char *bp = (unsigned char *)buffer;

	fd = open("/dev/urandom", O_RDONLY);
	if (fd == -1)
	{
		fd = open("/dev/random", O_RDONLY | O_NONBLOCK);
		if (fd == -1)
		{
			return (-1);
		}
	}

	while (n > 0)
	{
		i = read(fd, bp, n);
		if (i <= 0)
		{
			if (lose_counter++ > 16)
			{
				break;
			}
			continue;
		}
		n -= i;
		bp += i;
		lose_counter = 0;
	}
	close(fd);

	return (0);
}

static void random_buffer(void *buffer, size_t nbytes)
{

	if (true_random_buffer(buffer, nbytes) != 0)
	{
		printf("pseudo random\n");
		pseudo_random_buffer(buffer, nbytes);
	}

	return;
}

static int get_system_timestamp(uint64 *ret_timestamp)
{
	struct timeval tv;
	int adjustment = 10;

	gettimeofday(&tv, 0);

	*ret_timestamp = tv.tv_usec * 10 + adjustment;
	*ret_timestamp += ((uint64) tv.tv_sec) * 10000000;
	*ret_timestamp += (((uint64) TIME_OFFSET_HIGH) << 32) + TIME_OFFSET_LOW;

	return (0);
}

static int get_current_clock_seq(uint16 *ret_clock_seq)
{
	*ret_clock_seq = 0xFCCC & 0x1FFF;
	return (0);
}
static int get_system_time_and_clock(
		uint32 *clock_high,
		uint32 *clock_low,
		uint16 *ret_clock_seq)
{
	static int adjustment = 0;
	static struct timeval last = {0, 0};
	static uint16 clock_seq;
	struct timeval tv;
	uint64 clock_reg;
	
try_again:
	gettimeofday(&tv, 0);

	if ((last.tv_sec == 0) && (last.tv_usec == 0))
	{
		random_buffer(&clock_seq, sizeof(uint16));
		clock_seq &= 0x1FFF;
		last = tv;
		last.tv_sec--;
	}

	if ((tv.tv_sec <= last.tv_sec) && (tv.tv_usec < last.tv_usec))
	{
		clock_seq = (clock_seq + 1) & 0x1FFF;
		adjustment = 0;
		last = tv;
	}
	else if ((tv.tv_sec == last.tv_sec) && (tv.tv_usec == last.tv_usec))
	{
		if (adjustment >= MAX_ADJUSTMENT)
		{
			goto try_again;
		}
		adjustment++;
	}
	else
	{
		adjustment = 0;
		last = tv;
	}
		
	clock_reg = tv.tv_usec * 10 + adjustment;
	clock_reg += ((uint64) tv.tv_sec) * 10000000;
	clock_reg += (((uint64) TIME_OFFSET_HIGH) << 32) + TIME_OFFSET_LOW;

	*clock_high = clock_reg >> 32;
	*clock_low = clock_reg;
	*ret_clock_seq = clock_seq;

	return 0;
}

int generate_time(struct uuid *ret_uptr)
{
	static unsigned char node_id[6] = {0};
	static int has_init = 0;
	uint32 clock_mid;
	uint16 clock_seq;


	get_system_time_and_clock(&clock_mid, &(ret_uptr->time_low), 
&clock_seq);

	ret_uptr->clock_seq_low = clock_seq & 0xFF;
	ret_uptr->clock_seq_hi_and_reserved = ((clock_seq & 0x3F00) >> 8) | 
0x80;
	ret_uptr->clock_seq_hi_and_reserved |=  0x80;
	ret_uptr->time_mid = (uint16) clock_mid;
	ret_uptr->time_hi_and_version = (clock_mid >> 16) | 0x1000;

	memcpy(&(ret_uptr->node), node_id, 6);

	return (0);
}
