
-- Currencies
CREATE TABLE currencies (
   cur_id int2 not null primary key check (cur_id > 0),
   cur_name text not null,
   status char default 'A'
);

-- # COPY currencies FROM stdin USING DELIMITERS '|';
-- # 1| |A
-- # 2| |I
-- # 3| |I
-- # \.

CREATE TABLE currency_exch (
   cur_id int2 references currencies (cur_id),
   date_i date default current_date,
   roubles float not null
);

-- # COPY currency_exch FROM stdin USING DELIMITERS '|';
-- # 1|1998-01-01|1
-- # \.


-- Global parameters
CREATE TABLE param_int (
   param_id int4 not null primary key check (param_id > 0),
   param_name text not null,
   param_value int4 not null
);

-- # COPY param_int FROM stdin USING DELIMITERS '|';
-- # 1|  |7
-- # 2|mgr_main|0
-- # 3|shift_yesterday|20
-- # \.

CREATE TABLE param_str (
   param_id int4 not null primary key check (param_id > 0),
   param_name text not null,
   param_value text not null
);

-- # COPY param_str FROM stdin USING DELIMITERS '|';
-- # 1|HTDOCs|/ce/
-- # 2|CGIs|/cgi-bin/ce/
-- # 3|htdocs_dir|/usr/local/apache/share/htdocs/ce/
-- # 4|cgis_dir|/usr/local/apache/share/cgi-bin/ce/
-- # 5|incoming_maildir|/usr/local/apache/share/cgi-bin/ce/get_mail/mail/
-- # 6|director|
-- # \.

CREATE TABLE param_float (
   param_id int4 not null primary key check (param_id > 0),
   param_name text not null,
   param_value float not null
);

-- # COPY param_float FROM stdin USING DELIMITERS '|';
-- # 1|K_PROD|0.1
-- # 2|K_TIME|0.05
-- # 3|PRIM_RATING|1
-- # 4|MIN_AVG|3
-- # 5|DIFF_AVG|0.5
-- # 6|SEND_TIME|11
-- # 7|K_RATING|1
-- # 8|K_SHOP|1
-- # 9|CALCRATING_TIME|4
-- # 10|INACT_PERIOD|1
-- # 11|K_NEWSHOP|0
-- # 12|COR_PENALTY|100
-- # \.

CREATE TABLE param_datetime (
   param_id int4 not null primary key check (param_id > 0),
   param_name text not null,
   param_value datetime not null
);

CREATE TABLE palette (
   param_id int4 not null primary key check (param_id > 0),
   param_name text not null,
   param_value char(6)
);

-- # COPY palette FROM stdin USING DELIMITERS '|';
-- # 1|BgColor|
-- # 2|FgColor|
-- # 3|LiColor|
-- # 4|VLiColor|
-- # 5|ALiColor|
-- # \.


-- Units (gramms, liters, etc.)
CREATE TABLE units (
   unit_id int not null,
   unit_name varchar(10),
   coeff float,
   unit_to int references units (unit_id)
);

-- # COPY units FROM stdin USING DELIMITERS '|';
-- # 1||1|1
-- # 1|.|1|1
-- # 1||1|1
-- # 1|.|1|1
-- # 1||1|1
-- # 2||1000|1
-- # 2|.|1000|1
-- # 2||1000|1
-- # 3||0.001|4
-- # 3|.|0.001|4
-- # 4||1|4
-- # 4|.|1|4
-- # 4||1|4
-- # \.


-- Mail error codes
CREATE TABLE mail_ecod (
   ecod char not null primary key,
   estr varchar(100) not null unique
);

-- # COPY mail_ecod FROM stdin USING DELIMITERS '|';
-- # A|   
-- # B|    
-- # C|    
-- # D|    
-- # E|  
-- # F|  
-- # G| CSV-
-- # H|   
-- # J|CSV   
-- # K|   
-- # L|   
-- # M|  
-- # N| 
-- # O| 
-- # P| 
-- # Q|  
-- # R|  
-- # S|    
-- # T|  
-- # U|    
-- # V| 
-- # W| 
-- # X|    MIME   ZIP-
-- # Y|    CSV
-- # Z| ZIP.    insmail
-- # k|   
-- # l| 
-- # m|      
-- # n|  
-- # \.


-- Codificator for mk_activeselector()
CREATE TABLE status_code (
   status_code char not null primary key,
   status_name varchar(10) not null unique,
   rating int2 not null
);

-- # COPY status_code FROM stdin USING DELIMITERS '|';
-- # N||10
-- # A|.|20
-- # I|.|30
-- # D||40
-- # \.
