DROP TABLE table1;
DROP TABLE table2;

DROP VIEW view_test;

CREATE TABLE table1 (
	id integer,
	desc_t1 text,
	type_t1 varchar(1),
	ok integer,
	PRIMARY KEY (id)
);


CREATE TABLE table2 (
	id integer,
	desc_t2 text,
	type_t2 varchar(1),
	ok integer,
	PRIMARY KEY (id)
);

INSERT INTO table1 (id,desc_t1,type_t1,ok) VALUES (1,'John','T',0);
INSERT INTO table1 (id,desc_t1,type_t1,ok) VALUES (2,'Lewis','P',1);
INSERT INTO table1 (id,desc_t1,type_t1,ok) VALUES (3,'Richard','A',1);

INSERT INTO table2 (id,desc_t2,type_t2,ok) VALUES (1,'Catie','T',1);
INSERT INTO table2 (id,desc_t2,type_t2,ok) VALUES (2,'Jessica','P',2);
INSERT INTO table2 (id,desc_t2,type_t2,ok) VALUES (3,'Samantha','A',3);


CREATE VIEW "view_test" AS
SELECT t1.id, t1.desc_t1, t1.type_t1 as type1, t1.ok as ok1, t2.desc_t2, t2.type_t2 as type2, t2.ok as ok2
	FROM table1 t1 JOIN table2 t2 USING (id);

CREATE RULE "rule_test1" AS ON UPDATE TO "view_test"
	DO INSTEAD NOTHING;

CREATE RULE "rule_test2" AS ON UPDATE TO "view_test"
	WHERE OLD.ok2 = 1
	DO INSTEAD (
	UPDATE "table1"
		SET type_t1 = NEW.type2
		WHERE id = OLD.id;
	);

CREATE RULE "rule_test3" AS ON UPDATE TO "view_test"
	WHERE OLD.ok2 = 2
	DO INSTEAD (
	UPDATE "table2"
		SET type_t2 = NEW.type1
		WHERE id = OLD.id;
	);