/* PRODUKT     : 
 * SUBSYSTEM   : 
 * KOMPLEX     : 
 * HEADERNAME  : shm.h
 *
 *               System V Shared Memory Emulation
 */
/* DATUM       : 1999/11/12
 */
/* HISTORIE    :
 *
 * $Header$
 *
 * $Log$
 *
 * Copyright (c) 1999, repas AEG Automation GmbH
 *
 * ENDE HEADERKOPF
 */

/* -- MACROS UND KONSTANTEN ------------------------------------------------- */

#ifndef	_SYS_SHM_H
#define	_SYS_SHM_H

#include <sys/ipc.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define SHM_R	0400	/* read permission */
#define SHM_W	0200	/* write permission */

/* -- DATENTYPEN ------------------------------------------------------------ */

struct shmid_ds {
  int dummy;
};

/* -- VARIABLEN (REFERENZ) -------------------------------------------------- */

/* -- FUNKTIONEN (REFERENZ) ------------------------------------------------- */

extern void *shmat( int shmid, const void *shmaddr, int shmflg );
extern int shmdt( const void *addr );
extern int shmctl( int shmid, int cmd, struct shmid_ds *buf );
extern int shmget( key_t key, size_t size, int flags );

/* -------------------------------------------------------------------------- */

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_SHM_H */
