--
-- Tables for Transportable Optimizer Mode
--
-- simon@2ndquadrant.com

SET search_path=:TOM_SCHEMA;
SET client_min_messages=ERROR;

DROP TABLE IF EXISTS tom_mapping;
CREATE TABLE tom_mapping (
    local_relid oid not null,
	schemaname name not null,
	relname name not null
);

COMMENT on TABLE tom_mapping IS 
'Mapping between local catalog entries and tom_pg_statistic table';

CREATE UNIQUE INDEX tom_idx_on_tom_mapping_using_local_relid
ON tom_mapping USING btree (local_relid);

ALTER TABLE tom_mapping ADD PRIMARY KEY (schemaname, relname);

--
-- Tables, Indexes
--
DROP TABLE IF EXISTS tom_pg_class;
CREATE TABLE tom_pg_class (
	schemaname name not null,
	relname name not null,
	number_8kblocks integer not null,
	number_tuples bigint not null);

COMMENT on TABLE tom_pg_class IS 
'Mapping between local catalog entries and tom_pg_statistic table';

ALTER TABLE tom_pg_class ADD PRIMARY KEY (schemaname, relname);

--
-- Stats for Tables only at present
--
DROP TABLE IF EXISTS tom_pg_statistic;
CREATE TABLE tom_pg_statistic (
	schemaname name not null,
	relname name not null,
	attnum smallint not null,
    stanullfrac real NOT NULL,
    stawidth integer NOT NULL,
    stadistinct real NOT NULL,
    stakind1 smallint NOT NULL,
    stakind2 smallint NOT NULL,
    stakind3 smallint NOT NULL,
    stakind4 smallint NOT NULL,
    staop1 oid NOT NULL,
    staop2 oid NOT NULL,
    staop3 oid NOT NULL,
    staop4 oid NOT NULL,
    stanumbers1 real[],
    stanumbers2 real[],
    stanumbers3 real[],
    stanumbers4 real[],
    stavalues1 text,
    stavalues2 text,
    stavalues3 text,
    stavalues4 text
);

COMMENT on TABLE tom_pg_statistic IS 
'External data taken from remote pg_statistic tables plus objectnames';

ALTER TABLE tom_pg_statistic ADD PRIMARY KEY  (schemaname, relname, attnum);

RESET client_min_messages;

--
-- End of tables for Transportable Optimizer Mode
--
