#!/bin/bash
#
#   test_warm_standby.start.sh
#

export PRIMARYPORT=5442
echo $PRIMARYPORT

echo "-------------------------------------"
echo " cleanup and prepare for twin servers"
echo "-------------------------------------"
pg_ctl -w -D primary stop

rm -f -R primary

pg_ctl -w -D standby -m fast stop

rm -f -R standby

#remove trigger file, if present
rm -f /tmp/pgsql.trigger.$PRIMARYPORT

rm -f -R archive

mkdir archive
if [ ! $? == 0 ] ; then
    echo "could not create archive"
    exit
fi

echo "-------------------------------------"
echo " check access to pg_standby"
echo "-------------------------------------"
which pg_standby
if [ ! $? == 0 ] ; then
    echo "pg_standby unavailable - please install in path"
    exit
fi
pg_standby -d -s 1 -w 3 archive %f %p

echo "-------------------------------------"
echo " create primary data directory (only)"
echo "-------------------------------------"
initdb -D primary
if [ ! $? == 0 ] ; then
    echo "could not create primary data directory"
    exit
fi

echo "-------------------------------------"
echo " copying in primary .conf"
echo "-------------------------------------"
cp test_warm_standby.primary.postgresql.conf primary/postgresql.conf

echo "-------------------------------------"
echo " db start primary"
echo "-------------------------------------"
pg_ctl -w -D primary start
if [ ! $? == 0 ] ; then
    echo "could not start primary databse server"
    exit
fi

echo "-------------------------------------"
echo " register start backup with primary"
echo "-------------------------------------"
psql -c "select pg_start_backup('test_warm_standby');" -p $PRIMARYPORT postgres

if [ ! $? == 0 ] ; then
    echo "failed to start backup"
    exit
fi

echo "-------------------------------------"
echo " backing up primary ---> standby"
echo "-------------------------------------"
cp -R primary standby
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " register end of backup with primary"
echo "-------------------------------------"
psql -c "select pg_stop_backup();" -p $PRIMARYPORT postgres
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " copying in standby .conf"
echo "-------------------------------------"
cp test_warm_standby.standby.postgresql.conf standby/postgresql.conf
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " copying in recovery.conf"
echo "-------------------------------------"
cp test_warm_standby.standby.recovery.conf standby/recovery.conf
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " cleanup startup data directory"
echo "-------------------------------------"
rm standby/postmaster.pid
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " db start standby"
echo "-------------------------------------"
pg_ctl -D standby start
if [ ! $? == 0 ] ; then
    echo "Database failed to start"
    exit
fi

echo "-------------------------------------"
echo " check logs"
echo "      primary/pg_log/*"
echo "      standby/pg_log/*"
echo "      standby/pg_standby.log"
echo "-------------------------------------"


echo "-------------------------------------"
echo " run a large workload"
echo "-------------------------------------"
which pgbench
if [ ! $? == 0 ] ; then
    echo "pgbench unavailable - please install in path"
    exit
fi
pgbench -i -s 10 -p $PRIMARYPORT postgres
pgbench -c 4 -t 10000 -p $PRIMARYPORT postgres
