-- bench/load.sql
\set ON_ERROR_STOP 1

\if :{?nrows}
\else
  \set nrows 6000000
\endif
\if :{?ndistinct}
\else
  \set ndistinct 20000
\endif
\if :{?zipf_scale}
\else
  \set zipf_scale 10000
\endif

DROP TABLE IF EXISTS bench_xid;
DROP TABLE IF EXISTS bench_aclitem;

-- UNLOGGED: faster load; ANALYZE is CPU-bound for this benchmark.
CREATE UNLOGGED TABLE bench_xid AS
SELECT
  -- match-heavy: repeats values so most sampled rows are matches after fill.
  (((i - 1) % :ndistinct) + 3)::text::xid AS x_match,
  -- miss-heavy: unique per row.
  (i + 3)::text::xid AS x_unique,
  -- zipf-ish skew: mixes hits/misses and triggers candidate reordering.
  (floor(-log(random()) * :zipf_scale)::bigint + 3)::text::xid AS x_zipf
FROM generate_series(1, :nrows) AS i;

ALTER TABLE bench_xid SET (autovacuum_enabled = off);

CREATE UNLOGGED TABLE bench_aclitem AS
SELECT
  makeaclitem((((i - 1) % :ndistinct) + 3)::oid, 10::oid, 'SELECT'::text, false) AS x_match,
  makeaclitem((i + 3)::oid, 10::oid, 'SELECT'::text, false) AS x_unique,
  makeaclitem((floor(-log(random()) * :zipf_scale)::bigint + 3)::oid, 10::oid,
              'SELECT'::text, false) AS x_zipf
FROM generate_series(1, :nrows) AS i;

ALTER TABLE bench_aclitem SET (autovacuum_enabled = off);

\echo Loaded bench_xid and bench_aclitem with :nrows rows
