#!/usr/bin/env bash
set -euo pipefail

export PGPORT="${PGPORT:-54321}"
export PGDATABASE="${PGDATABASE:-bench}"

NROWS="${NROWS:-6000000}"
NDISTINCT="${NDISTINCT:-20000}"
ZIPF_SCALE="${ZIPF_SCALE:-10000}"

load_sql="bench/load.sql"

psql_base=(psql -X -v ON_ERROR_STOP=1)

if "${psql_base[@]}" -qAt -d postgres -c "SELECT 1" >/dev/null 2>&1; then
  if [[ "$("${psql_base[@]}" -qAt -d postgres \
      -c "SELECT 1 FROM pg_database WHERE datname = '${PGDATABASE}'" || true)" != "1" ]]; then
    "${psql_base[@]}" -d postgres -c "CREATE DATABASE \"${PGDATABASE}\"" >/dev/null 2>&1 || true
  fi
fi

"${psql_base[@]}" -d "${PGDATABASE}" \
  -v nrows="${NROWS}" \
  -v ndistinct="${NDISTINCT}" \
  -v zipf_scale="${ZIPF_SCALE}" \
  -f "${load_sql}"

