/*
 * bug_simulator.c
 *
 * Extracts the publish option from pg_ddl_command for testing.
 * On unpatched servers, this will show truncated values due to
 * DefElem corruption in parse_publication_options().
 */
#include "postgres.h"

#include "fmgr.h"
#include "nodes/parsenodes.h"
#include "nodes/value.h"
#include "tcop/deparse_utility.h"
#include "utils/builtins.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(get_publish_option);

/*
 * Returns the publish option value from a publication DDL command.
 *
 * On unpatched servers (before commit 936bc5c97f9), this returns
 * truncated values like "insert" instead of "insert,update,delete"
 * because copyObject() only copies up to the first NULL byte.
 */
Datum
get_publish_option(PG_FUNCTION_ARGS)
{
    CollectedCommand *cmd = (CollectedCommand *) PG_GETARG_POINTER(0);
    List       *options = NIL;
    ListCell   *lc;

    if (!cmd || !cmd->parsetree)
        PG_RETURN_NULL();

    if (IsA(cmd->parsetree, CreatePublicationStmt))
        options = ((CreatePublicationStmt *) cmd->parsetree)->options;
    else if (IsA(cmd->parsetree, AlterPublicationStmt))
        options = ((AlterPublicationStmt *) cmd->parsetree)->options;
    else
        PG_RETURN_NULL();

    foreach(lc, options)
    {
        DefElem    *defel = (DefElem *) lfirst(lc);

        if (strcmp(defel->defname, "publish") == 0)
        {
            char *val = pstrdup(strVal(defel->arg));
            PG_RETURN_TEXT_P(cstring_to_text(val));
        }
    }

    PG_RETURN_NULL();
}
