\set max_id :scale
\set batch_size :batch_size
\set full_refresh :full_refresh

BEGIN;
-- Update random existing lines
WITH update_targets AS (
    SELECT (random(1, :max_id)) AS target_invoice_id
    FROM generate_series(1, :batch_size)
)
UPDATE mv_benchmark.invoice_lines l
SET qty = qty + 1
FROM update_targets b
WHERE l.invoice_id = b.target_invoice_id;
COMMIT;

\if :full_refresh
REFRESH MATERIALIZED VIEW mv_benchmark.invoice_summary;
\endif
