\set max_id :scale
\set batch_size :batch_size
\set full_refresh :full_refresh

BEGIN;
-- Delete one line from random invoices to maintain roughly stable db size
WITH delete_targets AS (
    SELECT (random(1, :max_id)) AS target_invoice_id
    FROM generate_series(1, :batch_size)
)
DELETE FROM mv_benchmark.invoice_lines l
WHERE l.line_id IN (
    SELECT l2.line_id
    FROM delete_targets b
             JOIN mv_benchmark.invoice_lines l2 ON l2.invoice_id = b.target_invoice_id
    LIMIT 1
);
COMMIT;

\if :full_refresh
REFRESH MATERIALIZED VIEW mv_benchmark.invoice_summary;
\endif
